/*
 * Decompiled with CFR 0.152.
 */
package fermiumbooter.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Type;

public class ASMClassVisitor
extends ClassVisitor {
    private static final Type modType = Type.getType((String)"Lnet/minecraftforge/fml/common/Mod;");
    private static final Type configNameType = Type.getType((String)"Lnet/minecraftforge/common/config/Config$Name;");
    private static final Type mixinConfigType = Type.getType((String)"Lfermiumbooter/annotations/MixinConfig;");
    private static final Type mixinToggleType = Type.getType((String)"Lfermiumbooter/annotations/MixinConfig$MixinToggle;");
    private static final Type compatHandlingType = Type.getType((String)"Lfermiumbooter/annotations/MixinConfig$CompatHandling;");
    private static final Type compatHandlingContainerType = Type.getType((String)"Lfermiumbooter/annotations/MixinConfig$CompatHandlingContainer;");
    private ASMAnnotationVisitor modAnnoVisitor = null;
    private ASMAnnotationVisitor mixinConfigAnnoVisitor = null;
    private final List<ASMFieldVisitor> fieldVisitors = new ArrayList<ASMFieldVisitor>();
    private boolean parseFields = false;
    public String modid = null;
    public String mixinConfigName = null;
    public final List<ASMFieldVisitor> parsedFieldVisitors = new ArrayList<ASMFieldVisitor>();

    public ASMClassVisitor() {
        super(327680);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        Type type = Type.getType((String)desc);
        if (type.equals((Object)modType)) {
            this.modAnnoVisitor = new ASMAnnotationVisitor();
            return this.modAnnoVisitor;
        }
        if (type.equals((Object)mixinConfigType)) {
            this.mixinConfigAnnoVisitor = new ASMAnnotationVisitor();
            this.parseFields = true;
            return this.mixinConfigAnnoVisitor;
        }
        return null;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (!this.parseFields) {
            return null;
        }
        Type type = Type.getType((String)desc);
        if (type.equals((Object)Type.BOOLEAN_TYPE)) {
            ASMFieldVisitor booleanField = new ASMFieldVisitor();
            this.fieldVisitors.add(booleanField);
            return booleanField;
        }
        return null;
    }

    public void visitEnd() {
        if (this.modAnnoVisitor != null) {
            this.modid = (String)this.modAnnoVisitor.getValues().get("modid");
        }
        if (this.mixinConfigAnnoVisitor != null) {
            this.mixinConfigName = (String)this.mixinConfigAnnoVisitor.getValues().get("name");
            if (this.mixinConfigName == null || this.mixinConfigName.isEmpty()) {
                return;
            }
            for (ASMFieldVisitor fieldVisitor : this.fieldVisitors) {
                if (!fieldVisitor.valid) continue;
                this.parsedFieldVisitors.add(fieldVisitor);
            }
        }
    }

    public static class CompatHandlingAnnotation {
        public final String modid;
        public final boolean desired;
        public final boolean disableMixin;
        public final String reason;

        public CompatHandlingAnnotation(String modid, boolean desired, boolean disableMixin, String reason) {
            this.modid = modid;
            this.desired = desired;
            this.disableMixin = disableMixin;
            this.reason = reason;
        }
    }

    public static class ASMFieldVisitor
    extends FieldVisitor {
        private ASMAnnotationVisitor configNameVisitor = null;
        private ASMAnnotationVisitor mixinToggleVisitor = null;
        private final List<ASMAnnotationVisitor> compatHandlingVisitors = new ArrayList<ASMAnnotationVisitor>();
        public String configFieldName = null;
        public String earlyMixinName = null;
        public String lateMixinName = null;
        public boolean defaultValue = false;
        public final List<CompatHandlingAnnotation> compatHandlingAnnotations = new ArrayList<CompatHandlingAnnotation>();
        public boolean valid = false;

        public ASMFieldVisitor() {
            super(327680);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            Type type = Type.getType((String)desc);
            if (type.equals((Object)configNameType)) {
                this.configNameVisitor = new ASMAnnotationVisitor();
                return this.configNameVisitor;
            }
            if (type.equals((Object)mixinToggleType)) {
                this.mixinToggleVisitor = new ASMAnnotationVisitor();
                return this.mixinToggleVisitor;
            }
            if (type.equals((Object)compatHandlingType)) {
                ASMAnnotationVisitor compatHandlingVisitor = new ASMAnnotationVisitor();
                this.compatHandlingVisitors.add(compatHandlingVisitor);
                return compatHandlingVisitor;
            }
            if (type.equals((Object)compatHandlingContainerType)) {
                ASMAnnotationVisitor compatHandlingVisitor = new ASMAnnotationVisitor(this.compatHandlingVisitors);
                this.compatHandlingVisitors.add(compatHandlingVisitor);
                return compatHandlingVisitor;
            }
            return null;
        }

        public void visitEnd() {
            if (this.configNameVisitor != null && this.mixinToggleVisitor != null) {
                this.configFieldName = (String)this.configNameVisitor.getValues().get("value");
                if (this.configFieldName == null || this.configFieldName.isEmpty()) {
                    return;
                }
                this.earlyMixinName = (String)this.mixinToggleVisitor.getValues().get("earlyMixin");
                this.lateMixinName = (String)this.mixinToggleVisitor.getValues().get("lateMixin");
                if ((this.earlyMixinName == null || this.earlyMixinName.isEmpty()) && (this.lateMixinName == null || this.lateMixinName.isEmpty())) {
                    return;
                }
                Boolean defaultVal = (Boolean)this.mixinToggleVisitor.getValues().get("defaultValue");
                if (defaultVal == null) {
                    defaultVal = false;
                }
                this.defaultValue = defaultVal;
                this.valid = true;
                for (ASMAnnotationVisitor compatHandlingVisitor : this.compatHandlingVisitors) {
                    String reason;
                    Boolean disableMixin;
                    String modid = (String)compatHandlingVisitor.getValues().get("modid");
                    if (modid == null || modid.isEmpty()) continue;
                    Boolean desired = (Boolean)compatHandlingVisitor.getValues().get("desired");
                    if (desired == null) {
                        desired = true;
                    }
                    if ((disableMixin = (Boolean)compatHandlingVisitor.getValues().get("disableMixin")) == null) {
                        disableMixin = true;
                    }
                    if ((reason = (String)compatHandlingVisitor.getValues().get("reason")) == null) {
                        reason = "";
                    }
                    this.compatHandlingAnnotations.add(new CompatHandlingAnnotation(modid, desired, disableMixin, reason));
                }
            }
        }
    }

    public static class ASMAnnotationVisitor
    extends AnnotationVisitor {
        private final Map<String, Object> values = new HashMap<String, Object>();
        private List<ASMAnnotationVisitor> compatHandlingVisitors = null;

        public ASMAnnotationVisitor() {
            super(327680);
        }

        public ASMAnnotationVisitor(List<ASMAnnotationVisitor> compatHandlingVisitors) {
            super(327680);
            this.compatHandlingVisitors = compatHandlingVisitors;
        }

        public Map<String, Object> getValues() {
            return this.values;
        }

        public void visit(String name, Object value) {
            this.values.put(name, value);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            Type type;
            if (this.compatHandlingVisitors != null && (type = Type.getType((String)desc)).equals((Object)compatHandlingType)) {
                ASMAnnotationVisitor nestedCompatHandling = new ASMAnnotationVisitor();
                this.compatHandlingVisitors.add(nestedCompatHandling);
                return nestedCompatHandling;
            }
            return null;
        }

        public AnnotationVisitor visitArray(String name) {
            if (this.compatHandlingVisitors != null) {
                return new ASMAnnotationVisitor(this.compatHandlingVisitors);
            }
            return null;
        }
    }
}

