/*
 * Decompiled with CFR 0.152.
 */
package fermiumbooter;

import fermiumbooter.util.FermiumJarScanner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class FermiumRegistryAPI {
    private static final Logger LOGGER = LogManager.getLogger((String)"FermiumRegistryAPI");
    private static HashMap<String, List<Supplier<Boolean>>> earlyMixins = new HashMap();
    private static HashMap<String, List<Supplier<Boolean>>> lateMixins = new HashMap();
    private static List<String> rejectMixins = new ArrayList<String>();

    public static void enqueueMixin(boolean late, String ... configurations) {
        for (String configuration : configurations) {
            FermiumRegistryAPI.enqueueMixin(late, configuration);
        }
    }

    public static void enqueueMixin(boolean late, String configuration) {
        FermiumRegistryAPI.enqueueMixin(late, configuration, true);
    }

    public static void enqueueMixin(boolean late, String configuration, boolean enabled) {
        FermiumRegistryAPI.enqueueMixin(late, configuration, () -> enabled);
    }

    public static void enqueueMixin(boolean late, String configuration, Supplier<Boolean> supplier) {
        if (configuration == null || configuration.trim().isEmpty()) {
            LOGGER.log(Level.ERROR, "FermiumRegistryAPI supplied null or empty configuration name during mixin enqueue, ignoring.");
            return;
        }
        if (supplier == null) {
            LOGGER.log(Level.ERROR, "FermiumRegistryAPI supplied null supplier for configuration \"{}\" during mixin enqueue, ignoring.", (Object)configuration);
            return;
        }
        if (late) {
            LOGGER.log(Level.INFO, "FermiumRegistryAPI supplied \"{}\" for late mixin enqueue, adding.", (Object)configuration);
            lateMixins.computeIfAbsent(configuration, k -> new ArrayList());
            lateMixins.get(configuration).add(supplier);
        } else {
            LOGGER.log(Level.INFO, "FermiumRegistryAPI supplied \"{}\" for early mixin enqueue, adding.", (Object)configuration);
            earlyMixins.computeIfAbsent(configuration, k -> new ArrayList());
            earlyMixins.get(configuration).add(supplier);
        }
    }

    public static void removeMixin(String configuration) {
        if (configuration == null || configuration.trim().isEmpty()) {
            LOGGER.log(Level.ERROR, "FermiumRegistryAPI supplied null or empty configuration name for mixin removal, ignoring.");
            return;
        }
        LOGGER.log(Level.INFO, "FermiumRegistryAPI supplied \"{}\" for mixin removal, adding.", (Object)configuration);
        rejectMixins.add(configuration);
    }

    public static boolean isModPresent(String modID) {
        return FermiumJarScanner.isModPresent(modID);
    }

    public static HashMap<String, List<Supplier<Boolean>>> getEarlyMixins() {
        return earlyMixins;
    }

    public static HashMap<String, List<Supplier<Boolean>>> getLateMixins() {
        return lateMixins;
    }

    public static List<String> getRejectMixins() {
        return rejectMixins;
    }

    public static void clear() {
        earlyMixins = null;
        lateMixins = null;
        rejectMixins = null;
    }
}

