/*
 * Decompiled with CFR 0.152.
 */
package com.djcri.combatenhanced.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.LogManager;

public class Reflector<T> {
    private Object owner;
    private Class<?> ownerClass;
    private String name;
    private String nameObf;
    private Object[] params;

    public Reflector(Object owner, Class<?> ownerClass, String name, String nameObf, Object ... params) {
        this.owner = owner;
        this.ownerClass = ownerClass;
        this.name = name;
        this.nameObf = nameObf;
        this.params = params;
    }

    public T invokeMethod() {
        Method method = null;
        Object[] paramClasses = this.paramClasses(this.params);
        try {
            method = ReflectionHelper.findMethod(this.ownerClass, (String)this.name, (String)this.nameObf, (Class[])paramClasses);
        }
        catch (ReflectionHelper.UnableToFindMethodException exception) {
            this.throwError((Exception)((Object)exception), "Can't find method: " + this.ownerClass.getName() + '#' + this.name + ' ' + this.nameObf + '(' + Arrays.toString(paramClasses) + ')');
        }
        Object value = null;
        try {
            value = method.invoke(this.owner, this.params);
        }
        catch (Exception exception) {
            this.throwError(exception, "Can't invoke method: " + this.ownerClass.getName() + '#' + this.name + '(' + Arrays.toString(paramClasses) + ')');
        }
        return (T)value;
    }

    public Class<?>[] paramClasses(Object ... params) {
        Class[] classes = new Class[params.length];
        for (int p = 0; p < params.length; ++p) {
            classes[p] = params[p].getClass();
        }
        return classes;
    }

    public Field findField() {
        try {
            return ReflectionHelper.findField(this.ownerClass, (String[])new String[]{(Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment") != false ? this.name : this.nameObf});
        }
        catch (RuntimeException exception) {
            this.throwError(exception, "Can't find field: " + this.ownerClass.getName() + '#' + this.name);
            return null;
        }
    }

    public Field setField() {
        Field field = this.findField();
        try {
            field.set(this.owner, this.params[0]);
        }
        catch (IllegalAccessException exception) {
            this.throwError(exception, "Can't set field: " + this.ownerClass.getName() + '#' + this.name);
        }
        return field;
    }

    public T getField() {
        Field field = this.findField();
        Object value = null;
        try {
            value = field.get(this.owner);
        }
        catch (IllegalAccessException exception) {
            this.throwError(exception, "Can't get field: " + this.ownerClass.getName() + '#' + this.name);
        }
        return (T)value;
    }

    public void throwError(Exception e, String msg) {
        LogManager.getLogger((String)"REFLECTOR").error(msg);
        throw new RuntimeException(e);
    }
}

