/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.meson.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;

public class ItemHelper {
    public static List<ItemStack> availableTotems = new ArrayList<ItemStack>(){
        {
            new ItemStack(Items.field_190929_cY);
        }
    };
    public static List<ItemStack> curativeItems = new ArrayList<ItemStack>(){
        {
            new ItemStack(Items.field_151117_aB);
        }
    };

    public static List<ItemStack> getCurativeItems() {
        return curativeItems.stream().distinct().collect(Collectors.toList());
    }

    public static ItemStack getFilledWaterBottle() {
        return ItemHelper.getFilledWaterBottle(1);
    }

    public static ItemStack getFilledWaterBottle(int amount) {
        return ItemHelper.getPotionBottle(amount, PotionTypes.field_185230_b);
    }

    public static ItemStack getPotionBottle(int amount, PotionType type) {
        ItemStack out = new ItemStack((Item)Items.field_151068_bn, amount);
        PotionUtils.func_185188_a((ItemStack)out, (PotionType)type);
        return out;
    }

    public static boolean compareStacks(ItemStack s1, ItemStack s2) {
        return s1.func_77973_b() == s2.func_77973_b() && (s1.func_77960_j() == Short.MAX_VALUE || s1.func_77960_j() == s2.func_77960_j());
    }

    public static String getMatchingItemKey(List<String> items, ItemStack item) {
        String name = ItemHelper.getItemStringFromItemStack(item, true);
        if (items.contains(name)) {
            return name;
        }
        if (items.contains(name + "[*]")) {
            return name + "[*]";
        }
        String meta = "";
        if (name.contains("[")) {
            meta = name.substring(name.indexOf(91) + 1, name.indexOf(93));
            name = name.substring(0, name.indexOf(91));
        }
        if (items.contains(name)) {
            return name;
        }
        if (!meta.isEmpty() && items.contains(name + "[*]")) {
            return name + "[*]";
        }
        return "";
    }

    public static String getItemStringFromItemStack(ItemStack item, boolean withMeta) {
        String itemName = Objects.requireNonNull(item.func_77973_b().getRegistryName()).toString();
        int meta = withMeta ? item.func_77952_i() : 42;
        itemName = itemName + "[" + meta + "]";
        return itemName;
    }

    public static ItemStack getItemStackFromItemString(String name) {
        return ItemHelper.getItemStackFromItemString(name, 0);
    }

    public static ItemStack getItemStackFromItemString(String name, int defaultMeta) {
        Item item;
        ItemStack stack = null;
        String meta = "";
        if (name.contains("[")) {
            meta = name.substring(name.indexOf(91) + 1, name.indexOf(93));
            name = name.substring(0, name.indexOf(91));
        }
        if ((item = Item.func_111206_d((String)name)) != null) {
            stack = meta.equals("*") || meta.isEmpty() ? new ItemStack(item, 1, defaultMeta) : new ItemStack(item, 1, Integer.parseInt(meta));
        }
        return stack;
    }

    public static List<ItemStack> getItemStacksFromItemString(String name) {
        return ItemHelper.getItemStacksFromItemString(name, 0);
    }

    public static List<ItemStack> getItemStacksFromItemString(String name, int defaultMeta) {
        Item item;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        String meta = "";
        if (name.contains("[")) {
            meta = name.substring(name.indexOf(91) + 1, name.indexOf(93));
            name = name.substring(0, name.indexOf(91));
        }
        if ((item = Item.func_111206_d((String)name)) != null) {
            if (meta.equals("*") || meta.isEmpty()) {
                if (item.func_77614_k()) {
                    NonNullList subItems = NonNullList.func_191196_a();
                    item.func_150895_a(CreativeTabs.field_78027_g, subItems);
                    stacks.addAll((Collection<ItemStack>)subItems);
                } else {
                    stacks.add(new ItemStack(item, 1, defaultMeta));
                }
            } else {
                stacks.add(new ItemStack(item, 1, Integer.parseInt(meta)));
            }
        }
        return stacks;
    }
}

