/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.tweaks.feature;

import net.minecraft.block.BlockJukebox;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemRecord;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.client.event.sound.SoundEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import svenhjol.meson.Feature;
import svenhjol.meson.Meson;
import svenhjol.meson.helper.SoundHelper;

public class RecordsStopBackgroundMusic
extends Feature {
    public static int stopAfterTicks;
    private int ticks;
    private ISound currentMusic = null;

    @Override
    public String getDescription() {
        return "Stops the background music when playing a record in a jukebox to avoid a horrible cacophony.";
    }

    @Override
    public void configure() {
        super.configure();
        stopAfterTicks = 10;
    }

    @SubscribeEvent
    public void onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getWorld().field_72995_K) {
            IBlockState state = event.getWorld().func_180495_p(event.getPos());
            if (event.getEntity() instanceof EntityPlayer && event.getItemStack().func_77973_b() instanceof ItemRecord && state.func_177230_c() == Blocks.field_150421_aI && !((Boolean)state.func_177229_b((IProperty)BlockJukebox.field_176432_a)).booleanValue()) {
                SoundHelper.getPlayingSounds().forEach((id, sound) -> {
                    if (sound.func_184365_d() == SoundCategory.MUSIC) {
                        Meson.debug("Music playing before record started");
                        this.currentMusic = sound;
                    }
                });
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onSoundPlay(SoundEvent.SoundSourceEvent event) {
        ISound triggeredSound = event.getSound();
        if (triggeredSound.func_184365_d() == SoundCategory.MUSIC) {
            SoundHelper.getPlayingSounds().forEach((id, sound) -> {
                if (sound.func_184365_d() == SoundCategory.RECORDS) {
                    Meson.debug("Music tried to start while record playing");
                    this.currentMusic = triggeredSound;
                }
            });
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.currentMusic != null) {
            if (++this.ticks % stopAfterTicks > 0) {
                return;
            }
            Meson.debug("Stopping the music");
            SoundHelper.getSoundManager().func_148602_b(this.currentMusic);
            this.ticks = 0;
            this.currentMusic = null;
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }
}

