/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.enchanting.enchantment;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import svenhjol.charm.enchanting.feature.ExtraCurses;
import svenhjol.meson.MesonEnchantment;
import svenhjol.meson.helper.EnchantmentHelper;
import svenhjol.meson.iface.IMesonEnchantment;

public class EnchantmentHarmingCurse
extends MesonEnchantment
implements IMesonEnchantment.ICurse {
    private int amount = ExtraCurses.harmingDamageAmount;
    private double chance = ExtraCurses.harmingDamageChance;

    public EnchantmentHarmingCurse() {
        super("harming_curse", Enchantment.Rarity.VERY_RARE, EnumEnchantmentType.ALL, EntityEquipmentSlot.MAINHAND);
    }

    @Override
    public String getModId() {
        return "charm";
    }

    @Override
    public void onBreak(EntityPlayer player, BlockEvent.BreakEvent event) {
        if (this.isHeldItemEnchanted(player, this)) {
            this.tryDamage(player);
        }
    }

    @Override
    public void onAttack(EntityPlayer player, AttackEntityEvent event) {
        if (this.isHeldItemEnchanted(player, this)) {
            this.tryDamage(player);
        }
    }

    @Override
    public void onDamage(EntityPlayer player, LivingDamageEvent event) {
        for (ItemStack item : player.func_184209_aF()) {
            if (!EnchantmentHelper.hasEnchantment(this, item)) continue;
            this.tryDamage(player);
        }
    }

    @Override
    public void onInteract(EntityPlayer player, PlayerInteractEvent.RightClickBlock event) {
        if (this.isHeldItemEnchanted(player, this)) {
            this.tryDamage(player);
        }
    }

    @Override
    public void onItemUseStop(EntityPlayer player, LivingEntityUseItemEvent.Stop event) {
        if (this.isHeldItemEnchanted(player, this)) {
            this.tryDamage(player);
        }
    }

    private void tryDamage(EntityPlayer player) {
        if ((double)player.field_70170_p.field_73012_v.nextFloat() < this.chance) {
            player.func_70097_a(DamageSource.field_76376_m, (float)this.amount);
        }
    }
}

