/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.crafting.feature;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import svenhjol.charm.base.CharmLootTables;
import svenhjol.charm.crafting.block.BlockCrate;
import svenhjol.charm.crafting.client.RenderTileCrate;
import svenhjol.charm.crafting.tile.TileCrate;
import svenhjol.meson.Feature;
import svenhjol.meson.MesonBlock;
import svenhjol.meson.MesonItemBlock;
import svenhjol.meson.handler.RecipeHandler;
import svenhjol.meson.helper.ItemNBTHelper;
import svenhjol.meson.helper.LootHelper;
import svenhjol.meson.registry.ProxyRegistry;

public class Crate
extends Feature {
    public static BlockCrate crate;
    public static BlockCrate crateSealed;
    public static float hardness;
    public static boolean showCrateNames;
    public static int xpCost;
    public static boolean crateTooltip;
    public static boolean requireShift;
    public static ResourceLocation WIDGET_RESOURCE;
    public static List<Class<? extends Block>> blacklist;
    public static Map<RARITY, List<CrateType>> types;

    public static CrateType getRandomCrateType(RARITY r) {
        Random rand = new Random();
        List<CrateType> t = types.get((Object)r);
        return t.get(rand.nextInt(t.size()));
    }

    @Override
    public String getDescription() {
        return "Offers a smaller storage solution with the benefit of being transportable.  Name your crate on an anvil to change the displayed label.\nYou can also seal the crate by combining it with an iron ingot - the only way to get things out is to break it.";
    }

    @Override
    public void configure() {
        super.configure();
        xpCost = this.propInt("XP cost", "Amount of XP (levels) required to use a name tag to seal a crate.", 0);
        crateTooltip = this.propBoolean("Crate tooltip", "Shows tooltip containing crate contents when hovering over the crate in the inventory.", true);
        requireShift = this.propBoolean("Tooltip shift key", "Crate tooltip needs the shift key held down to be visible", false);
        hardness = 2.0f;
        showCrateNames = true;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        crate = new BlockCrate(BlockCrate.Type.CRATE);
        crateSealed = new BlockCrate(BlockCrate.Type.CRATE_SEALED);
        GameRegistry.registerTileEntity(crate.getTileEntityClass(), (ResourceLocation)new ResourceLocation("charm:crate"));
        blacklist.add(BlockCrate.class);
        blacklist.add(BlockShulkerBox.class);
        HashMap<RARITY, List<ResourceLocation>> map = new HashMap<RARITY, List<ResourceLocation>>(){
            {
                this.put(RARITY.COMMON, LootHelper.getLootTables(LootHelper.RARITY.COMMON, LootHelper.TYPE.MISC));
                this.put(RARITY.UNCOMMON, LootHelper.getLootTables(LootHelper.RARITY.UNCOMMON, LootHelper.TYPE.MISC));
                this.put(RARITY.VALUABLE, LootHelper.getLootTables(LootHelper.RARITY.VALUABLE, LootHelper.TYPE.MISC));
                this.put(RARITY.RARE, LootHelper.getLootTables(LootHelper.RARITY.RARE, LootHelper.TYPE.MISC));
            }
        };
        for (RARITY rarity : map.keySet()) {
            List tables = (List)map.get((Object)rarity);
            ArrayList<CrateType> crates = new ArrayList<CrateType>();
            for (ResourceLocation res : tables) {
                String[] a = res.func_110623_a().split("/");
                crates.add(new CrateType(a.length > 1 ? a[1] : a[0], res));
            }
            types.put(rarity, crates);
        }
        types.get((Object)RARITY.VALUABLE).add(new CrateType("dangerous", CharmLootTables.TREASURE_DANGEROUS));
        types.get((Object)RARITY.RARE).add(new CrateType("explosive", CharmLootTables.TREASURE_EXPLOSIVE));
        for (int i = 0; i < MesonBlock.WoodVariant.values().length; ++i) {
            RecipeHandler.addShapedRecipe(ProxyRegistry.newStack(crate, 1, i), "IWI", "W W", "IWI", Character.valueOf('W'), ProxyRegistry.newStack(Blocks.field_150344_f, 1, i), Character.valueOf('I'), "ingotIron");
        }
    }

    public static ItemStack getSealedCrateItem(ItemStack in, String name) {
        NBTTagCompound inTag;
        ItemStack out = new ItemStack((Block)crateSealed, 1, in.func_77952_i());
        if (name == null || name.isEmpty()) {
            name = in.func_82833_r();
        }
        NBTTagCompound outTag = (inTag = in.func_77978_p()) != null && !inTag.func_82582_d() && !inTag.func_74775_l("BlockEntityTag").func_82582_d() ? inTag.func_74737_b() : out.func_190925_c("BlockEntityTag");
        outTag.func_74775_l("BlockEntityTag");
        out.func_77982_d(outTag);
        out.func_151001_c(name);
        return out;
    }

    public static void generateCrate(World world, BlockPos pos, CrateType crateType, IBlockState state) {
        world.func_180501_a(pos, state, 2);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCrate) {
            TileCrate crate = (TileCrate)tile;
            crate.setName(crateType.name);
            crate.setShowName(true);
            crate.setLootTable(crateType.pool);
            crate.func_70296_d();
        }
    }

    @SubscribeEvent
    public void onAnvilRepair(AnvilRepairEvent event) {
        ItemStack in = event.getItemInput();
        ItemStack combine = event.getIngredientInput();
        if (in.func_190926_b() || !combine.func_190926_b()) {
            return;
        }
        if (!this.isItemCrate(in)) {
            return;
        }
        event.setBreakChance(0.0f);
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack in = event.getLeft();
        ItemStack combine = event.getRight();
        if (in.func_190926_b() && combine.func_190926_b()) {
            return;
        }
        if (this.isItemCrate(in)) {
            ItemStack out = null;
            int cost = 0;
            if (combine.func_77973_b() == Items.field_151057_cb) {
                out = in.func_77946_l();
                cost = in.func_190916_E();
                NBTTagCompound be = this.getBlockEntityTag(out);
                be.func_74757_a("showname", true);
            }
            if (!this.isSealedCrate(in) && combine.func_77973_b() == Items.field_151042_j) {
                cost = Math.min(in.func_190916_E(), combine.func_190916_E());
                String name = in.func_82833_r();
                out = Crate.getSealedCrateItem(in, name);
            }
            if (out != null) {
                out.func_190920_e(cost);
                event.setCost(xpCost);
                event.setMaterialCost(cost);
                event.setOutput(out);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void makeTooltip(ItemTooltipEvent event) {
        NBTTagCompound tag;
        if (!event.getItemStack().func_190926_b() && event.getItemStack().func_77973_b() instanceof MesonItemBlock && ((MesonItemBlock)event.getItemStack().func_77973_b()).func_179223_d() instanceof BlockCrate && event.getItemStack().func_77942_o() && !(tag = ItemNBTHelper.getCompound(event.getItemStack(), "BlockEntityTag")).func_82582_d()) {
            List tooltip = event.getToolTip();
            ArrayList tooltipCopy = new ArrayList(tooltip);
            for (int i = 1; i < tooltipCopy.size(); ++i) {
                String s = (String)tooltipCopy.get(i);
                if (s.startsWith("\u00a7") && !s.startsWith("\u00a7o")) continue;
                tooltip.remove(s);
            }
            if (requireShift && !GuiScreen.func_146272_n()) {
                tooltip.add(1, I18n.func_135052_a((String)"charm.crate_tooltip_shift", (Object[])new Object[0]));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderTooltip(RenderTooltipEvent.PostText event) {
        NBTTagCompound tag;
        if (!event.getStack().func_190926_b() && event.getStack().func_77973_b() instanceof MesonItemBlock && ((MesonItemBlock)event.getStack().func_77973_b()).func_179223_d() instanceof BlockCrate && event.getStack().func_77942_o() && (!requireShift || GuiScreen.func_146272_n()) && !(tag = ItemNBTHelper.getCompound(event.getStack(), "BlockEntityTag")).func_82582_d() && tag.func_74764_b("inventory") && !tag.func_74775_l("inventory").func_150295_c("Items", 10).func_82582_d()) {
            NonNullList items = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)tag.func_74775_l("inventory"), (NonNullList)items);
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution res = new ScaledResolution(mc);
            if (((BlockCrate)((MesonItemBlock)event.getStack().func_77973_b()).func_179223_d()).isSealedCrate() && !mc.field_71439_g.func_184812_l_()) {
                return;
            }
            int x = event.getX() - 5;
            int y = event.getY() - 35;
            int w = 172;
            int h = 64;
            int right = x + w;
            if (y < 0) {
                y = event.getY() + event.getLines().size() * 10 + 5;
            }
            if (right > res.func_78326_a()) {
                x -= right - res.func_78326_a();
            }
            GlStateManager.func_179094_E();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)700.0f);
            mc.func_110434_K().func_110577_a(WIDGET_RESOURCE);
            RenderHelper.func_74518_a();
            Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)w, (int)h, (float)256.0f, (float)256.0f);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            RenderItem render = mc.func_175599_af();
            RenderHelper.func_74520_c();
            GlStateManager.func_179126_j();
            int i = 0;
            for (ItemStack item : items) {
                int xp = x + 6 + i % 9 * 18;
                int yp = y + 6 + i / 9 * 18;
                if (!item.func_190926_b()) {
                    render.func_180450_b(item, xp, yp);
                    render.func_175030_a(mc.field_71466_p, item, xp, yp);
                }
                ++i;
            }
            GlStateManager.func_179097_i();
            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();
        }
    }

    public static boolean canInsertItem(ItemStack stack) {
        Class<?> clazz = Block.func_149634_a((Item)stack.func_77973_b()).getClass();
        return !blacklist.contains(clazz);
    }

    protected NBTTagCompound getBlockEntityTag(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b("BlockEntityTag")) {
            stack.func_190925_c("BlockEntityTag");
            tag = stack.func_77978_p();
        }
        return tag.func_74775_l("BlockEntityTag");
    }

    protected boolean isItemCrate(ItemStack stack) {
        return Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockCrate;
    }

    protected boolean isSealedCrate(ItemStack stack) {
        return this.isItemCrate(stack) && ((BlockCrate)Block.func_149634_a((Item)stack.func_77973_b())).isSealedCrate();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitClient(FMLPreInitializationEvent event) {
        if (showCrateNames) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileCrate.class, (TileEntitySpecialRenderer)new RenderTileCrate());
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    static {
        blacklist = new ArrayList<Class<? extends Block>>();
        types = new HashMap<RARITY, List<CrateType>>();
        WIDGET_RESOURCE = new ResourceLocation("charm", "textures/misc/crate_widget.png");
    }

    public class CrateType {
        public String name;
        public String id;
        public ResourceLocation pool;

        public CrateType(String id, ResourceLocation pool) {
            this.id = id;
            this.name = net.minecraft.util.text.translation.I18n.func_74838_a((String)id) + " " + net.minecraft.util.text.translation.I18n.func_74838_a((String)"crate");
            this.pool = pool;
        }
    }

    public static enum RARITY {
        COMMON,
        UNCOMMON,
        VALUABLE,
        RARE;

    }
}

