/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.crafting.block;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import svenhjol.charm.Charm;
import svenhjol.charm.base.CharmSounds;
import svenhjol.charm.crafting.feature.Crate;
import svenhjol.charm.crafting.tile.TileCrate;
import svenhjol.meson.Meson;
import svenhjol.meson.MesonBlock;
import svenhjol.meson.MesonBlockTE;
import svenhjol.meson.helper.EntityHelper;
import svenhjol.meson.helper.SoundHelper;
import svenhjol.meson.iface.IMesonBlock;
import svenhjol.meson.iface.IMesonEnum;

public class BlockCrate
extends MesonBlockTE<TileCrate>
implements IMesonBlock {
    public static PropertyEnum<MesonBlock.WoodVariant> VARIANT = PropertyEnum.func_177709_a((String)"variant", MesonBlock.WoodVariant.class);
    public Type type;

    public BlockCrate(Type type) {
        super(Material.field_151575_d, type.func_176610_l());
        this.func_149711_c(Crate.hardness);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.type = type;
    }

    @Override
    public String getModId() {
        return "charm";
    }

    @Override
    public String[] getVariants() {
        ArrayList<String> variants = new ArrayList<String>();
        for (MesonBlock.WoodVariant variant : MesonBlock.WoodVariant.values()) {
            variants.add(variant.toString().toLowerCase());
        }
        return variants.toArray(new String[0]);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }

    @Override
    public void doItemSpawn(ItemStack stack, World world, BlockPos pos) {
        if (EntityHelper.itemHasEntityTag(stack)) {
            EntityHelper.spawnEntityFromItem(stack, world, pos);
        } else if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockTNT) {
            EntityTNTPrimed tnt = new EntityTNTPrimed(world, (double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f), null);
            if (world.func_72838_d((Entity)tnt)) {
                SoundHelper.playSoundAtPos(world, tnt.func_180425_c(), SoundEvents.field_187904_gd, 1.0f, 1.0f);
            }
        } else {
            super.doItemSpawn(stack, world, pos);
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (world.field_72995_K && this.validTileEntity(this.getTileEntity((IBlockAccess)world, pos)) && this.isSealedCrate()) {
            SoundHelper.playSoundAtPos(world, pos, CharmSounds.WOOD_SMASH, 0.6f, 1.0f);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileCrate crate = (TileCrate)this.getTileEntity((IBlockAccess)world, pos);
        if (this.validTileEntity(crate)) {
            if (this.isSealedCrate()) {
                this.dropsInventory(crate, 9, world, pos);
            } else {
                ItemStack stack = new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(state));
                NBTTagCompound tag = new NBTTagCompound();
                crate.func_189515_b(tag);
                stack.func_77983_a("BlockEntityTag", (NBTBase)tag);
                tag.func_82580_o("x");
                tag.func_82580_o("y");
                tag.func_82580_o("z");
                if (crate.hasCustomName()) {
                    stack.func_151001_c(crate.getName());
                }
                BlockCrate.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileCrate crate = (TileCrate)this.getTileEntity((IBlockAccess)world, pos);
        if (this.validTileEntity(crate)) {
            world.func_180501_a(pos, state, 2);
            if (stack.func_77978_p() != null) {
                crate.setLootTable(stack.func_77978_p().func_74779_i("lootTable"));
                String name = stack.func_82833_r();
                if (!name.isEmpty()) {
                    crate.setName(name);
                }
                this.func_176213_c(world, pos, state);
            }
        } else {
            super.func_180633_a(world, pos, state, placer, stack);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileCrate crate = (TileCrate)this.getTileEntity((IBlockAccess)world, pos);
        if (!this.validTileEntity(crate)) {
            return false;
        }
        if (Meson.DEBUG && player.func_184812_l_() && player.func_70093_af() && player.func_184586_b(hand) == ItemStack.field_190927_a) {
            this.setCreativeLootTable(world, pos);
            world.func_184138_a(pos, state, state, 2);
            return false;
        }
        if (crate.hasLootTable()) {
            crate.generateLoot(player);
        }
        if (this.isSealedCrate()) {
            return true;
        }
        if (player.func_70093_af()) {
            return false;
        }
        if (!world.field_72995_K) {
            player.openGui((Object)Charm.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        if (world.field_72995_K && !this.isSealedCrate()) {
            player.func_184185_a(CharmSounds.WOOD_OPEN, 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    public Class<TileCrate> getTileEntityClass() {
        return TileCrate.class;
    }

    @Override
    @Nullable
    public TileCrate createTileEntity(World world, IBlockState state) {
        return new TileCrate();
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return !this.isSealedCrate();
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.isSealedCrate() ? 0 : 50;
    }

    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public int func_176201_c(IBlockState state) {
        return ((MesonBlock.WoodVariant)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)MesonBlock.WoodVariant.byMetadata(meta)));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(world.func_180495_p(pos)));
    }

    public boolean isSealedCrate() {
        return this.type == Type.CRATE_SEALED;
    }

    public void setCreativeLootTable(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            float f = world.field_73012_v.nextFloat();
            Crate.RARITY rarity = Crate.RARITY.COMMON;
            if ((double)f <= 0.25) {
                rarity = Crate.RARITY.RARE;
            } else if ((double)f <= 0.5) {
                rarity = Crate.RARITY.VALUABLE;
            } else if ((double)f <= 0.75) {
                rarity = Crate.RARITY.UNCOMMON;
            }
            TileCrate tile = (TileCrate)this.getTileEntity((IBlockAccess)world, pos);
            List<Crate.CrateType> types = Crate.types.get((Object)rarity);
            Crate.CrateType type = types.get(world.field_73012_v.nextInt(types.size()));
            int slots = tile.getInventory().getSlots();
            for (int i = 0; i < slots; ++i) {
                tile.getInventory().getStackInSlot(i).func_190920_e(0);
            }
            tile.setLootTable(type.pool);
            tile.setName(type.pool.toString());
            tile.setShowName(true);
        } else {
            for (int i = 0; i < 8; ++i) {
                double d0 = world.field_73012_v.nextGaussian() * 0.02;
                double d1 = world.field_73012_v.nextGaussian() * 0.02;
                double d2 = world.field_73012_v.nextGaussian() * 0.02;
                double dx = (float)pos.func_177958_n() + MathHelper.func_76131_a((float)world.field_73012_v.nextFloat(), (float)0.25f, (float)0.75f);
                double dy = (float)pos.func_177956_o() + 1.35f;
                double dz = (float)pos.func_177952_p() + MathHelper.func_76131_a((float)world.field_73012_v.nextFloat(), (float)0.25f, (float)0.75f);
                world.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, dx, dy, dz, d0, d1, d2, new int[0]);
            }
        }
    }

    public static enum Type implements IMesonEnum
    {
        CRATE,
        CRATE_SEALED;

    }
}

