/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.deadmanssatchel.network.packet;

import com.builtbroken.deadmanssatchel.config.SatchelWorldData;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SatchelWorldConfigurationPacket
implements IMessage {
    public SatchelWorldData data;
    public String satchelName;
    public int dimID;

    public SatchelWorldConfigurationPacket() {
    }

    public SatchelWorldConfigurationPacket(SatchelWorldData data, int dimID, String satchelName) {
        this.data = data;
        this.satchelName = satchelName;
        this.dimID = dimID;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.satchelName.length());
        buf.writeCharSequence((CharSequence)this.satchelName, StandardCharsets.UTF_8);
        buf.writeInt(this.dimID);
        buf.writeBoolean(this.data.only_owner_open);
        buf.writeInt(this.data.death_drop_timer);
        buf.writeInt(this.data.re_open_timer);
        buf.writeFloat(this.data.random_bag_drop_chance);
        buf.writeInt(this.data.random_bag_items_drop_chance.size());
        for (String registry : this.data.random_bag_items_drop_chance.keySet()) {
            buf.writeInt(registry.length());
            buf.writeCharSequence((CharSequence)registry, StandardCharsets.UTF_8);
            buf.writeFloat(this.data.random_bag_items_drop_chance.get(registry).floatValue());
        }
    }

    public void fromBytes(ByteBuf buf) {
        int nameLength = buf.readInt();
        this.satchelName = buf.readCharSequence(nameLength, StandardCharsets.UTF_8).toString();
        this.dimID = buf.readInt();
        boolean onlyOwner = buf.readBoolean();
        int dropTimer = buf.readInt();
        int openTimer = buf.readInt();
        float randomBagDropChance = buf.readFloat();
        int listSize = buf.readInt();
        HashMap<String, Float> map = new HashMap<String, Float>();
        for (int i = 0; i < listSize; ++i) {
            int stringLength = buf.readInt();
            String key = buf.readCharSequence(stringLength, StandardCharsets.UTF_8).toString();
            map.put(key, Float.valueOf(buf.readFloat()));
        }
        this.data = new SatchelWorldData(openTimer, dropTimer, randomBagDropChance, map, onlyOwner);
    }
}

