/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.deadmanssatchel.network.packet;

import com.builtbroken.deadmanssatchel.config.SatchelGlobalData;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SatchelGlobalConfigurationPacket
implements IMessage {
    public SatchelGlobalData data;
    public String satchelName;

    public SatchelGlobalConfigurationPacket() {
    }

    public SatchelGlobalConfigurationPacket(SatchelGlobalData data, String satchelName) {
        this.data = data;
        this.satchelName = satchelName;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.satchelName.length());
        buf.writeCharSequence((CharSequence)this.satchelName, StandardCharsets.UTF_8);
        buf.writeBoolean(this.data.only_owner_open);
        buf.writeBoolean(this.data.is_blacklist);
        buf.writeInt(this.data.death_drop_timer);
        buf.writeInt(this.data.re_open_timer);
        buf.writeFloat(this.data.random_bag_drop_chance);
        buf.writeInt(this.data.slot_count);
        buf.writeInt(this.data.item_list.length);
        for (String item : this.data.item_list) {
            buf.writeInt(item.length());
            buf.writeCharSequence((CharSequence)item, StandardCharsets.UTF_8);
        }
        buf.writeInt(this.data.random_bag_items_drop_chance.size());
        for (String registry : this.data.random_bag_items_drop_chance.keySet()) {
            buf.writeInt(registry.length());
            buf.writeCharSequence((CharSequence)registry, StandardCharsets.UTF_8);
            buf.writeFloat(((Float)this.data.random_bag_items_drop_chance.get(registry)).floatValue());
        }
    }

    public void fromBytes(ByteBuf buf) {
        int nameLength = buf.readInt();
        this.satchelName = buf.readCharSequence(nameLength, StandardCharsets.UTF_8).toString();
        boolean onlyOwner = buf.readBoolean();
        boolean isBlackList = buf.readBoolean();
        int dropTimer = buf.readInt();
        int openTimer = buf.readInt();
        float randomBagDropChance = buf.readFloat();
        int slotCount = buf.readInt();
        int listSize = buf.readInt();
        String[] itemList = new String[listSize];
        for (int i = 0; i < listSize; ++i) {
            int stringLength = buf.readInt();
            itemList[i] = buf.readCharSequence(stringLength, StandardCharsets.UTF_8).toString();
        }
        int listSize2 = buf.readInt();
        HashMap<String, Float> map = new HashMap<String, Float>();
        for (int i = 0; i < listSize2; ++i) {
            int stringLength = buf.readInt();
            String key = buf.readCharSequence(stringLength, StandardCharsets.UTF_8).toString();
            map.put(key, Float.valueOf(buf.readFloat()));
        }
        this.data = new SatchelGlobalData(itemList, isBlackList, openTimer, dropTimer, slotCount, randomBagDropChance, map, onlyOwner);
    }
}

