/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.deadmanssatchel.item;

import com.builtbroken.deadmanssatchel.SatchelMod;
import com.builtbroken.deadmanssatchel.item.SatchelCapabilityProvider;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ItemDeadMansSatchel
extends Item {
    public final int defaultSlotCount;

    public ItemDeadMansSatchel(String registryName, int defaultSlotCount) {
        this.func_77625_d(1);
        this.setRegistryName(registryName);
        this.func_77655_b("satchels." + registryName);
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.defaultSlotCount = defaultSlotCount;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!SatchelMod.canOpenBag(player, (ItemDeadMansSatchel)stack.func_77973_b())) {
            return super.func_77659_a(world, player, hand);
        }
        boolean onlyOwner = SatchelMod.getConfig((World)world, (ItemDeadMansSatchel)this).only_owner_open;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound compound = stack.func_77978_p();
        UUID playerUUID = player.func_146103_bH().getId();
        if (compound.func_74764_b("Owner")) {
            UUID storedUUID;
            if (onlyOwner && !playerUUID.equals(storedUUID = UUID.fromString(compound.func_74779_i("Owner")))) {
                return super.func_77659_a(world, player, hand);
            }
        } else {
            compound.func_74778_a("Owner", playerUUID.toString());
        }
        player.openGui((Object)SatchelMod.mod, 0, world, hand.ordinal(), 0, 0);
        return super.func_77659_a(world, player, hand);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new SatchelCapabilityProvider(stack, nbt, SatchelMod.getSlotCount(this));
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Owner")) {
            String uString = stack.func_77978_p().func_74779_i("Owner");
            tooltip.add("Owner: " + uString);
            if (stack.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && (!SatchelMod.getConfig((World)worldIn, (ItemDeadMansSatchel)((ItemDeadMansSatchel)stack.func_77973_b())).only_owner_open || Minecraft.func_71410_x().field_71439_g.func_146103_bH().getId().equals(UUID.fromString(uString)))) {
                ItemStackHandler handler = (ItemStackHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                HashMap<String, Integer> items = new HashMap<String, Integer>();
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack slotstack = handler.getStackInSlot(i);
                    String itemStr = slotstack.func_77973_b().func_77667_c(slotstack);
                    if (itemStr.equalsIgnoreCase("tile.air")) continue;
                    if (!items.containsKey(itemStr)) {
                        items.put(itemStr, slotstack.func_190916_E());
                        continue;
                    }
                    items.put(itemStr, (Integer)items.get(itemStr) + slotstack.func_190916_E());
                }
                if (items.size() > 0) {
                    tooltip.add("Contains:");
                } else {
                    tooltip.add("No contents");
                }
                for (String key : items.keySet()) {
                    int count = (Integer)items.get(key);
                    tooltip.add(count + "x" + I18n.func_135052_a((String)(key + ".name"), (Object[])new Object[0]));
                }
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

