/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.deadmanssatchel;

import com.builtbroken.deadmanssatchel.config.SatchelConfiguration;
import com.builtbroken.deadmanssatchel.config.SatchelGlobalData;
import com.builtbroken.deadmanssatchel.config.SatchelWorldData;
import com.builtbroken.deadmanssatchel.config.WorldBagConfiguration;
import com.builtbroken.deadmanssatchel.gui.GuiProxy;
import com.builtbroken.deadmanssatchel.item.ItemDeadMansSatchel;
import com.builtbroken.deadmanssatchel.network.SatchelGlobalConfigPacketHandler;
import com.builtbroken.deadmanssatchel.network.SatchelWorldConfigPacketHandler;
import com.builtbroken.deadmanssatchel.network.packet.SatchelGlobalConfigurationPacket;
import com.builtbroken.deadmanssatchel.network.packet.SatchelWorldConfigurationPacket;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="deadmanssatchel")
@Mod(modid="deadmanssatchel", name="Dead Man's Satchel", version="1.12.2-1.0.0.20190226202924", acceptedMinecraftVersions="[1.12.2]")
public class SatchelMod {
    @Mod.Instance(value="deadmanssatchel")
    public static SatchelMod mod;
    public static final String MODID = "deadmanssatchel";
    public static final String NAME = "Dead Man's Satchel";
    public static final String MAJOR_VERSION = "1";
    public static final String MINOR_VERSION = "0";
    public static final String REVISION_VERSION = "0";
    public static final String BUILD_VERSION = "20190226202924";
    public static final String MC_VERSION = "1.12.2";
    public static final String VERSION = "1.12.2-1.0.0.20190226202924";
    public static final SimpleNetworkWrapper WRAPPER_INSTANCE;
    private static File directory;
    public static File globalFile;
    private static Map<Integer, WorldBagConfiguration> configs;
    private static Map<String, SatchelGlobalData> globalData;
    public static final ItemDeadMansSatchel satchelBasic;
    public static HashMap<Pair<String, String>, Integer> openTimers;
    public static HashMap<Pair<String, String>, Integer> reDropTimers;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        directory = event.getModConfigurationDirectory();
        globalFile = new File(directory.getPath() + "/deadmanssatchel/global.json");
        SatchelMod.loadGlobalConfig();
        SatchelConfiguration.genDefaultWorld(new File(directory.getPath() + "/deadmanssatchel/", "DIM#.example.json"));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)mod, (IGuiHandler)new GuiProxy());
        WRAPPER_INSTANCE.registerMessage(SatchelGlobalConfigPacketHandler.class, SatchelGlobalConfigurationPacket.class, 0, Side.CLIENT);
        WRAPPER_INSTANCE.registerMessage(SatchelWorldConfigPacketHandler.class, SatchelWorldConfigurationPacket.class, 1, Side.CLIENT);
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        SatchelMod.loadGlobalConfig();
        for (WorldServer world : DimensionManager.getWorlds()) {
            int dimID = world.field_73011_w.getDimension();
            String dir = directory.getPath() + "/deadmanssatchel/";
            File worldFile = new File(dir, "DIM" + dimID + ".json");
            if (worldFile.exists()) {
                configs.put(dimID, SatchelConfiguration.loadWorld(worldFile));
                continue;
            }
            configs.put(dimID, new WorldBagConfiguration(SatchelConfiguration.globalDataMap, false));
        }
    }

    private static void loadGlobalConfig() {
        String dir = directory.getPath() + "/deadmanssatchel/";
        File dirF = new File(dir);
        if (!dirF.exists()) {
            dirF.mkdirs();
        }
        if (!globalFile.exists()) {
            try {
                globalFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            SatchelConfiguration.genDefaultGlobal(globalFile);
        }
        for (ItemDeadMansSatchel satchel : SatchelMod.getBags()) {
            SatchelGlobalData data = SatchelConfiguration.loadGlobal(globalFile, satchel);
            globalData.put(satchel.getRegistryName().toString(), data);
        }
    }

    public static SatchelWorldData getConfig(World world, ItemDeadMansSatchel satchel) {
        int dimID = world.field_73011_w.getDimension();
        WorldBagConfiguration config = configs.get(dimID);
        return config.satchels.get(satchel.getRegistryName().toString());
    }

    public static SatchelGlobalData getGlobalData(ItemDeadMansSatchel satchel) {
        return globalData.get(satchel.getRegistryName().toString());
    }

    public static int getSlotCount(ItemDeadMansSatchel satchel) {
        try {
            return SatchelMod.getGlobalData((ItemDeadMansSatchel)satchel).slot_count;
        }
        catch (NullPointerException e) {
            return satchel.defaultSlotCount;
        }
    }

    @SubscribeEvent
    public static void syncConfigs(PlayerEvent.PlayerLoggedInEvent event) {
        for (String name : globalData.keySet()) {
            WRAPPER_INSTANCE.sendTo((IMessage)new SatchelGlobalConfigurationPacket(globalData.get(name), name), (EntityPlayerMP)event.player);
        }
        Iterator<Object> iterator = configs.keySet().iterator();
        while (iterator.hasNext()) {
            int dimID = (Integer)iterator.next();
            WorldBagConfiguration cfg = configs.get(dimID);
            Map<String, SatchelWorldData> dataMap = cfg.satchels;
            for (String name : dataMap.keySet()) {
                WRAPPER_INSTANCE.sendTo((IMessage)new SatchelWorldConfigurationPacket(dataMap.get(name), dimID, name), (EntityPlayerMP)event.player);
            }
        }
    }

    public static void loadClientConfigFromNetwork(SatchelWorldData data, int dimID, String bag) {
        if (!configs.containsKey(dimID)) {
            configs.put(dimID, new WorldBagConfiguration(new HashMap<String, SatchelWorldData>()));
        }
        Map<String, SatchelWorldData> bagList = SatchelMod.configs.get((Object)Integer.valueOf((int)dimID)).satchels;
        bagList.put(bag, data);
    }

    public static void loadClientConfigFromNetwork(SatchelGlobalData data, String bagName) {
        globalData.put(bagName, data);
    }

    public static ItemDeadMansSatchel[] getBags() {
        return new ItemDeadMansSatchel[]{satchelBasic};
    }

    public static Set<String> getBagRegistryNames() {
        HashSet<String> set = new HashSet<String>();
        for (ItemDeadMansSatchel satchel : SatchelMod.getBags()) {
            set.add(satchel.getRegistryName().toString());
        }
        return set;
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])SatchelMod.getBags());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void playerDrop(PlayerDropsEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        ArrayList<EntityItem> toRemove = new ArrayList<EntityItem>();
        for (EntityItem drop : event.getDrops()) {
            if (!(drop.func_92059_d().func_77973_b() instanceof ItemDeadMansSatchel)) continue;
            toRemove.add(drop);
        }
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < toRemove.size(); ++i) {
            boolean doRemove;
            ItemStack stack = ((EntityItem)toRemove.get(i)).func_92059_d();
            ItemDeadMansSatchel satchel = (ItemDeadMansSatchel)stack.func_77973_b();
            SatchelWorldData bagCfg = SatchelMod.getConfig(player.func_130014_f_(), satchel);
            int openTimer = bagCfg.re_open_timer;
            if (openTimer != 0) {
                Pair newPair = Pair.of((Object)player.func_146103_bH().getId().toString(), (Object)satchel.getRegistryName().func_110623_a());
                openTimers.put((Pair<String, String>)newPair, openTimer * 20);
            }
            int reDropTimer = bagCfg.death_drop_timer;
            Pair<String, String> pair = null;
            for (Pair<String, String> pairI : reDropTimers.keySet()) {
                if (!((String)pairI.getLeft()).equals(player.func_146103_bH().getId().toString()) || !((String)pairI.getRight()).equals(satchel.getRegistryName().func_110623_a())) continue;
                pair = pairI;
            }
            boolean bl = doRemove = pair == null;
            if (!doRemove || !(Math.random() > (double)bagCfg.random_bag_drop_chance)) continue;
            ItemStackHandler handler = (ItemStackHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            for (int j = 0; j < handler.getSlots(); ++j) {
                ItemStack stackJ = handler.getStackInSlot(j);
                String key = stackJ.func_77973_b().getRegistryName().toString();
                if (!bagCfg.random_bag_items_drop_chance.containsKey(key)) continue;
                float dropChance = bagCfg.random_bag_items_drop_chance.get(key).floatValue();
                if (!(Math.random() < (double)dropChance)) continue;
                ItemStack drop = handler.extractItem(j, stackJ.func_190916_E(), false);
                player.func_146097_a(drop, true, false);
            }
            if (reDropTimer > 0) {
                Pair newPair = Pair.of((Object)player.func_146103_bH().getId().toString(), (Object)satchel.getRegistryName().func_110623_a());
                reDropTimers.put((Pair<String, String>)newPair, reDropTimer * 20);
            }
            tagList.func_74742_a((NBTBase)stack.func_77955_b(new NBTTagCompound()));
            event.getDrops().remove(toRemove.get(i));
        }
        if (!tagList.func_82582_d()) {
            player.getEntityData().func_74782_a("satchelData", (NBTBase)tagList);
            player.getEntityData().func_74757_a("hasSatchel", true);
        }
    }

    @SubscribeEvent
    public static void playerCloned(PlayerEvent.Clone event) {
        EntityPlayer player;
        if (event.isWasDeath() && (player = event.getOriginal()).getEntityData().func_74767_n("hasSatchel")) {
            NBTTagList tagList = player.getEntityData().func_150295_c("satchelData", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                ItemStack stack = new ItemStack(tagList.func_150305_b(i));
                event.getEntityPlayer().func_191521_c(stack);
            }
            player.getEntityData().func_82580_o("satchelData");
            player.getEntityData().func_74757_a("hasSatchel", false);
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        HashSet<Pair<String, String>> toRemove = new HashSet<Pair<String, String>>();
        for (Pair<String, String> pair : openTimers.keySet()) {
            int n = openTimers.get(pair);
            if (n > 0) {
                openTimers.put(pair, --n);
                continue;
            }
            if (n > 0) continue;
            toRemove.add(pair);
        }
        for (Pair pair : toRemove) {
            openTimers.remove(pair);
        }
        HashSet<Pair<String, String>> toRemove2 = new HashSet<Pair<String, String>>();
        for (Pair<String, String> pair : reDropTimers.keySet()) {
            int time = reDropTimers.get(pair);
            if (time > 0) {
                reDropTimers.put(pair, --time);
                continue;
            }
            if (time > 0) continue;
            toRemove2.add(pair);
        }
        for (Pair pair : toRemove2) {
            reDropTimers.remove(pair);
        }
    }

    public static boolean canOpenBag(EntityPlayer player, ItemDeadMansSatchel satchel) {
        if (player.func_184812_l_()) {
            return false;
        }
        Pair<String, String> pair = null;
        for (Pair<String, String> pairI : openTimers.keySet()) {
            if (!((String)pairI.getLeft()).equals(player.func_146103_bH().getId().toString()) || !((String)pairI.getRight()).equals(satchel.getRegistryName().func_110623_a())) continue;
            pair = pairI;
        }
        return pair == null;
    }

    static {
        WRAPPER_INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        directory = null;
        globalFile = null;
        configs = new HashMap<Integer, WorldBagConfiguration>();
        globalData = new HashMap<String, SatchelGlobalData>();
        satchelBasic = new ItemDeadMansSatchel(MODID, 6);
        openTimers = new HashMap();
        reDropTimers = new HashMap();
    }
}

