/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialai.util;

import fathertoast.specialai.SpecialAIMod;
import fathertoast.specialai.config.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class NameHelperVillager {
    private static final String TAG_CAREER = "Career";
    private static final int[] NAME_PART_CHANCES = new int[]{1, 1, 4, 16, 64};
    private static final Map<String, String[]> CAREER_TITLES = new HashMap<String, String[]>();
    private static final Map<String, List<String>> NAME_POOLS = new HashMap<String, List<String>>();

    private static String getKey(VillagerRegistry.VillagerProfession profession) {
        return profession.getRegistryName().toString();
    }

    private static String getKey(VillagerRegistry.VillagerCareer career, VillagerRegistry.VillagerProfession profession) {
        return NameHelperVillager.getKey(NameHelperVillager.getKey(profession), career.getName());
    }

    private static String getKey(String profKey, String careerName) {
        return profKey + "#" + careerName;
    }

    public static void setVillagerName(Random random, EntityVillager entity) {
        String[] titles;
        NBTTagCompound tag = new NBTTagCompound();
        entity.func_70014_b(tag);
        VillagerRegistry.VillagerProfession prof = entity.getProfessionForge();
        VillagerRegistry.VillagerCareer career = prof.getCareer(tag.func_74762_e(TAG_CAREER) - 1);
        String profKey = NameHelperVillager.getKey(prof);
        String careerKey = NameHelperVillager.getKey(career, prof);
        ArrayList namePool = new ArrayList(NAME_POOLS.get(""));
        if (NAME_POOLS.containsKey(profKey)) {
            namePool.addAll(NAME_POOLS.get(profKey));
        }
        if (NAME_POOLS.containsKey(careerKey)) {
            namePool.addAll(NAME_POOLS.get(careerKey));
        }
        if ((titles = CAREER_TITLES.get(careerKey)) == null) {
            if (Config.get().GENERAL.DEBUG) {
                SpecialAIMod.log().warn("Naming villager with unknown profession#career '{}'", (Object)careerKey);
            }
            ArrayList<String[]> values = new ArrayList<String[]>(CAREER_TITLES.values());
            titles = (String[])values.get(random.nextInt(values.size()));
        }
        StringBuilder name = new StringBuilder(32);
        for (int chance : NAME_PART_CHANCES) {
            if (random.nextInt(chance) != 0) continue;
            name.append((String)namePool.get(random.nextInt(namePool.size())));
        }
        name.setCharAt(0, Character.toUpperCase(name.charAt(0)));
        if (random.nextInt(100) == 0) {
            name.insert(0, random.nextBoolean() ? "Mc" : "Mac");
        }
        String title = titles[random.nextInt(titles.length)];
        if (random.nextInt(3) == 0) {
            name.append(" the ").append(title);
        } else {
            name.insert(0, " ").insert(0, title);
        }
        entity.func_96094_a(name.toString());
    }

    static {
        NAME_POOLS.put("", Arrays.asList("grab", "thar", "ger", "ald", "mas", "on", "o", "din", "thor", "jon", "ath", "an", "burb", "en", "a", "e", "i", "u", "hab", "bloo", "ena", "dit", "aph", "ern", "bor", "dav", "id", "toast", "son", "dottir", "for", "wen", "lob", "ed", "die", "van", "y", "zap", "ear", "ben", "don", "bran", "gro", "jen", "bob", "ette", "ere", "man", "qua", "bro", "cree", "per", "skel", "ton", "zom", "bie", "wolf", "end", "er", "pig", "sil", "ver", "fish", "cow", "chic", "ken", "sheep", "lla", "rab", "bit", "squid", "hell"));
        String prof = "minecraft:farmer";
        String careerKey = NameHelperVillager.getKey(prof, "farmer");
        CAREER_TITLES.put(careerKey, new String[]{"Farmer", "Farmer", "Gardener", "Gardener", "Seedmonger", "Seedmonger", "Cropper", "Greenskeeper", "Agriculturalist", "Horticulturist", "Seedsman", "Landscaper", "Seedvendor"});
        NAME_POOLS.put(careerKey, Arrays.asList("farm", "garden", "soil", "seed", "plant", "crop", "green", "wheat", "carrot", "potato", "beet", "hoe"));
        careerKey = NameHelperVillager.getKey(prof, "fisherman");
        CAREER_TITLES.put(careerKey, new String[]{"Fisherman", "Fisherman", "Fisher", "Fisher", "Angler", "Angler", "Fishmonger", "Fishmonger", "Piscator", "Rodman", "Troller", "Trawler", "Fishman", "Skipper", "Captain", "Fishvendor"});
        NAME_POOLS.put(careerKey, Arrays.asList("fish", "sea", "boat", "salt", "rod", "cast", "net", "gold", "treasure", "sunken", "oar", "plank", "beard"));
        careerKey = NameHelperVillager.getKey(prof, "shepherd");
        CAREER_TITLES.put(careerKey, new String[]{"Shepherd", "Shepherd", "Rancher", "Rancher", "Herder", "Herder", "Cowhand", "Herdsman", "Cowpuncher", "Sheepsman", "Sheeper", "Cooper", "Stockman"});
        NAME_POOLS.put(careerKey, Arrays.asList("herd", "ranch", "brand", "cow", "sheep", "chicken", "pig", "horse", "fence", "gate", "post", "hay"));
        careerKey = NameHelperVillager.getKey(prof, "fletcher");
        CAREER_TITLES.put(careerKey, new String[]{"Fletcher", "Fletcher", "Bowyer", "Bowyer", "Arrowvendor", "Arrowvendor", "Arrowman", "Bowman", "Arrowcrafter", "Bowcrafter", "Bowvendor", "Arrowmonger", "Bowmonger"});
        NAME_POOLS.put(careerKey, Arrays.asList("arrow", "feather", "string", "bow", "archer", "shoot", "poke"));
        prof = "minecraft:librarian";
        careerKey = NameHelperVillager.getKey(prof, "librarian");
        CAREER_TITLES.put(careerKey, new String[]{"Librarian", "Librarian", "Curator", "Curator", "Bookbinder", "Bookbinder", "Bookvendor", "Bookvendor", "Cataloger", "Researcher", "Bookman", "Bibliothecary", "Recordkeeper", "Bookmonger"});
        NAME_POOLS.put(careerKey, Arrays.asList("book", "shelf", "wise", "read", "bind", "record", "biblio", "libro", "lib"));
        careerKey = NameHelperVillager.getKey(prof, "cartographer");
        CAREER_TITLES.put(careerKey, new String[]{"Cartographer", "Cartographer", "Mapmaker", "Mapmaker", "Explorer", "Explorer", "Mapvendor", "Mapvendor", "Topographer", "Mapper", "Adventurer", "Pathfinder", "Pioneer", "Mapmonger", "Wayfinder"});
        NAME_POOLS.put(careerKey, Arrays.asList("map", "dora", "venture", "carto", "topo", "way", "path", "find", "treasure"));
        prof = "minecraft:priest";
        careerKey = NameHelperVillager.getKey(prof, "cleric");
        CAREER_TITLES.put(careerKey, new String[]{"Cleric", "Cleric", "Cleric", "Priest", "Priest", "Priest", "Father", "Mother", "Preacher", "Reverend", "Rabbi", "Chaplain", "Minister", "Churchman", "Healer", "Storyteller", "Mystic", "Enchanter", "Diviner", "Oracle", "Augur", "Prophet", "Seer", "Holyman", "Sage", "Wiseman", "Elder"});
        NAME_POOLS.put(careerKey, Arrays.asList("holy", "wise", "mystic", "secret", "cleric", "priest", "div"));
        prof = "minecraft:smith";
        careerKey = NameHelperVillager.getKey(prof, "armor");
        CAREER_TITLES.put(careerKey, new String[]{"Armorsmith", "Armorsmith", "Armorer", "Armorer", "Armorworker", "Armorworker", "Armorvendor", "Armorvendor", "Armormaster", "Armorman", "Armorcrafter", "Plateworker", "Platesmith", "Platecrafter", "Shieldworker", "Shieldsmith", "Shieldcrafter", "Armormonger", "Platemonger", "Platevendor", "Shieldmonger", "Shieldvendor"});
        NAME_POOLS.put(careerKey, Arrays.asList("armor", "plate", "shield", "smith", "forge", "fire", "anvil"));
        careerKey = NameHelperVillager.getKey(prof, "weapon");
        CAREER_TITLES.put(careerKey, new String[]{"Weaponsmith", "Weaponsmith", "Swordsmith", "Swordsmith", "Weaponmonger", "Weaponmonger", "Weaponcrafter", "Weaponmaker", "Weaponmaster", "Weaponman", "Swordcrafter", "Swordmaker", "Swordmaster", "Weaponvendor", "Swordmonger", "Swordvendor"});
        NAME_POOLS.put(careerKey, Arrays.asList("weapon", "sword", "poker", "smith", "forge", "fire", "anvil"));
        careerKey = NameHelperVillager.getKey(prof, "tool");
        CAREER_TITLES.put(careerKey, new String[]{"Toolsmith", "Toolsmith", "Toolmaker", "Toolmaker", "Toolvendor", "Toolvendor", "Toolworker", "Toolcrafter", "Toolman", "Toolmaster", "Tooler", "Artisan", "Toolmonger"});
        NAME_POOLS.put(careerKey, Arrays.asList("tool", "pick", "axe", "shovel", "hoe", "hammer", "smith", "forge", "fire", "anvil"));
        prof = "minecraft:butcher";
        careerKey = NameHelperVillager.getKey(prof, "butcher");
        CAREER_TITLES.put(careerKey, new String[]{"Butcher", "Butcher", "Meatman", "Meatman", "Meatmonger", "Meatmonger", "Meatvendor", "Cowslayer", "Sheepslayer", "Chickenslayer", "Rabbitslayer"});
        NAME_POOLS.put(careerKey, Arrays.asList("butcher", "blood", "meat", "chop", "cleave", "hook"));
        careerKey = NameHelperVillager.getKey(prof, "leather");
        CAREER_TITLES.put(careerKey, new String[]{"Tanner", "Tanner", "Leathermaker", "Leathermaker", "Leathermonger", "Leathermonger", "Leatherman", "Skinner", "Cowskinner", "Sheepskinner", "Hidetanner", "Leathertanner", "Leathervendor"});
        NAME_POOLS.put(careerKey, Arrays.asList("tan", "leather", "hide", "skin", "strip", "chop", "cleave", "blood"));
        prof = "minecraft:nitwit";
        careerKey = NameHelperVillager.getKey(prof, "nitwit");
        CAREER_TITLES.put(careerKey, new String[]{"Nitwit", "Blockhead", "Fool", "Dimwit", "Dork", "Dunce", "Jerk", "Moron", "Pinhead", "Ninny", "Simpleton"});
        NAME_POOLS.put(careerKey, Arrays.asList("fool", "dork", "jerk", "wit", "genius", "head", "smart", "wise"));
    }
}

