/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialai.ai.grief;

import fathertoast.specialai.config.Config;
import fathertoast.specialai.config.TargetBlock;
import fathertoast.specialai.util.BlockHelper;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityAIBreakDoorSpecial
extends EntityAIBreakDoor {
    private float doorBreakSpeed;
    private boolean doorNeedsTarget;
    private boolean doorNeedsTool;
    private TargetBlock.TargetMap doorTargetBlocks;
    private boolean completed;
    private float initialDoorVecX;
    private float initialDoorVecZ;
    private IBlockState targetBlock;
    private int hitCounter;
    private float blockDamage;
    private int lastBlockDamage = -1;

    public EntityAIBreakDoorSpecial(EntityLiving entity, NBTTagCompound tag) {
        super(entity);
        this.func_75248_a(0);
        this.doorBreakSpeed = tag.func_74764_b("DoorBreakSpeed") ? tag.func_74760_g("DoorBreakSpeed") : Config.get().DOOR_BREAKING.BREAK_SPEED;
        this.doorNeedsTarget = tag.func_74764_b("DoorNeedsTarget") ? tag.func_74767_n("DoorNeedsTarget") : Config.get().DOOR_BREAKING.REQUIRES_TARGET;
        this.doorNeedsTool = tag.func_74764_b("DoorNeedsTool") ? tag.func_74767_n("DoorNeedsTool") : Config.get().DOOR_BREAKING.REQUIRES_TOOLS;
        this.doorTargetBlocks = tag.func_74764_b("DoorBlocks") ? TargetBlock.newTargetDefinition(tag.func_74779_i("DoorBlocks")) : Config.get().DOOR_BREAKING.TARGET_LIST;
    }

    public boolean func_75250_a() {
        if (!this.field_75356_a.field_70123_F || !ForgeEventFactory.getMobGriefingEvent((World)this.field_75356_a.field_70170_p, (Entity)this.field_75356_a) || this.doorNeedsTarget && this.field_75356_a.func_70638_az() == null && this.field_75356_a.func_70643_av() == null || !this.findObstructingDoor()) {
            return false;
        }
        IBlockState doorState = this.field_75356_a.field_70170_p.func_180495_p(this.field_179507_b);
        return doorState.func_177230_c().canEntityDestroy(doorState, (IBlockAccess)this.field_75356_a.field_70170_p, this.field_179507_b, (Entity)this.field_75356_a) && ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)this.field_75356_a, (BlockPos)this.field_179507_b, (IBlockState)doorState);
    }

    private boolean findObstructingDoor() {
        PathNavigateGround navigator = (PathNavigateGround)this.field_75356_a.func_70661_as();
        Path path = navigator.func_75505_d();
        if (path != null && !path.func_75879_b() && navigator.func_179686_g()) {
            int maxPoint = Math.min(path.func_75873_e() + 2, path.func_75874_d());
            for (int i = 0; i < maxPoint; ++i) {
                double dZ;
                PathPoint pathpoint = path.func_75877_a(i);
                BlockPos footPos = new BlockPos(pathpoint.field_75839_a, pathpoint.field_75837_b, pathpoint.field_75838_c);
                double dX = (double)footPos.func_177958_n() - this.field_75356_a.field_70165_t;
                if (!(dX * dX + (dZ = (double)footPos.func_177952_p() - this.field_75356_a.field_70161_v) * dZ <= 2.25) || !this.tryTargetDoor(footPos)) continue;
                return true;
            }
            return this.tryTargetDoor(new BlockPos((Entity)this.field_75356_a));
        }
        return false;
    }

    private boolean tryTargetDoor(BlockPos footPos) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(footPos.func_177958_n(), footPos.func_177956_o() - 1 + (int)Math.ceil(this.field_75356_a.field_70131_O), footPos.func_177952_p());
        while (pos.func_177956_o() >= footPos.func_177956_o()) {
            IBlockState target = this.field_75356_a.field_70170_p.func_180495_p((BlockPos)pos);
            if (this.doorTargetBlocks.matches(target) && BlockHelper.shouldDamage(target, this.field_75356_a, this.doorNeedsTool && !this.madCreeper(), this.field_75356_a.field_70170_p, (BlockPos)pos)) {
                this.targetBlock = target;
                this.field_179507_b = pos.func_185334_h();
                return true;
            }
            pos.func_185336_p(pos.func_177956_o() - 1);
        }
        return false;
    }

    public void func_75249_e() {
        if (this.madCreeper()) {
            ((EntityCreeper)this.field_75356_a).func_146079_cb();
            this.completed = true;
        } else {
            this.completed = false;
            this.initialDoorVecX = (float)((double)((float)this.field_179507_b.func_177958_n() + 0.5f) - this.field_75356_a.field_70165_t);
            this.initialDoorVecZ = (float)((double)((float)this.field_179507_b.func_177952_p() + 0.5f) - this.field_75356_a.field_70161_v);
            this.hitCounter = 0;
            this.blockDamage = 0.0f;
            this.lastBlockDamage = -1;
        }
    }

    public boolean func_75253_b() {
        return !this.completed && this.field_75356_a.func_174818_b(this.field_179507_b) < 4.0;
    }

    public void func_75251_c() {
        this.blockDamage = 0.0f;
        this.targetBlock = null;
        this.field_75356_a.field_70170_p.func_175715_c(this.field_75356_a.func_145782_y(), this.field_179507_b, -1);
    }

    public void func_75246_d() {
        int damage;
        float doorVecZ;
        float doorVecX = (float)((double)((float)this.field_179507_b.func_177958_n() + 0.5f) - this.field_75356_a.field_70165_t);
        float projection = this.initialDoorVecX * doorVecX + this.initialDoorVecZ * (doorVecZ = (float)((double)((float)this.field_179507_b.func_177952_p() + 0.5f) - this.field_75356_a.field_70161_v));
        if (projection < 0.0f) {
            this.completed = true;
        }
        if (this.hitCounter == 0) {
            this.field_75356_a.func_184609_a(EnumHand.MAIN_HAND);
            this.field_75356_a.field_70170_p.func_175718_b(this.targetBlock.func_185904_a() == Material.field_151573_f || this.targetBlock.func_185904_a() == Material.field_151574_g ? 1020 : 1019, this.field_179507_b, 0);
        }
        if (++this.hitCounter >= 16) {
            this.hitCounter = 0;
        }
        this.blockDamage += BlockHelper.getDamageAmount(this.targetBlock, this.field_75356_a, this.field_75356_a.field_70170_p, this.field_179507_b) * this.doorBreakSpeed;
        if (this.blockDamage >= 1.0f) {
            this.field_75356_a.field_70170_p.func_175655_b(this.field_179507_b, Config.get().DOOR_BREAKING.LEAVE_DROPS);
            this.field_75356_a.field_70170_p.func_175718_b(1021, this.field_179507_b, 0);
            this.field_75356_a.func_184609_a(EnumHand.MAIN_HAND);
            this.blockDamage = 0.0f;
            this.completed = true;
        }
        if ((damage = (int)Math.ceil(this.blockDamage * 10.0f) - 1) != this.lastBlockDamage) {
            this.field_75356_a.field_70170_p.func_175715_c(this.field_75356_a.func_145782_y(), this.field_179507_b, damage);
            this.lastBlockDamage = damage;
        }
    }

    private boolean madCreeper() {
        return Config.get().DOOR_BREAKING.MAD_CREEPERS && this.field_75356_a instanceof EntityCreeper;
    }
}

