/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialai.ai.elite;

import fathertoast.specialai.ai.elite.EliteAIHandler;
import fathertoast.specialai.ai.elite.IEliteAI;
import fathertoast.specialai.config.Config;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.EnumHand;

public class EntityAIThrowPlayer
extends EntityAIBase
implements IEliteAI {
    private static final double SPEED_TO_PLAYER = 1.2;
    private static final double SPEED_TO_TARGET = 1.3;
    private static final byte STATE_END = 0;
    private static final byte STATE_GRAB = 1;
    private static final byte STATE_CARRY = 2;
    private int WEIGHT;
    protected EntityLiving theEntity;
    private byte state;
    private EntityLiving throwTarget;
    private int attackTime;
    private int giveUpDelay;
    private int extraGrabAttempts;

    EntityAIThrowPlayer() {
    }

    private EntityAIThrowPlayer(EntityLiving entity) {
        this.theEntity = entity;
        this.func_75248_a(3);
    }

    @Override
    public String getName() {
        return "throw_player";
    }

    @Override
    public int getWeight() {
        return this.WEIGHT;
    }

    @Override
    public void setWeight(int weight) {
        this.WEIGHT = weight;
    }

    @Override
    public void addTo(EntityLiving entity, NBTTagCompound aiTag) {
        entity.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIThrowPlayer(entity));
    }

    @Override
    public void save(NBTTagCompound aiTag) {
        aiTag.func_74774_a(this.getName(), (byte)1);
    }

    @Override
    public boolean isSaved(NBTTagCompound aiTag) {
        return aiTag.func_74771_c(this.getName()) > 0;
    }

    @Override
    public void initialize(EntityLiving entity) {
        ItemStack helmet = new ItemStack((Item)Items.field_151024_Q);
        if (Config.get().ELITE_AI.THROW_PLAYER_HELMET_DAMAGE > 0.0) {
            helmet.func_151001_c("Helmet of Strength");
            EliteAIHandler.addModifierToItem(helmet, SharedMonsterAttributes.field_111264_e, Config.get().ELITE_AI.THROW_PLAYER_HELMET_DAMAGE, EliteAIHandler.AttributeModOperation.ADDITION);
        }
        Items.field_151024_Q.func_82813_b(helmet, 0xFF0000);
        entity.func_184201_a(EntityEquipmentSlot.HEAD, helmet);
        entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(new AttributeModifier(UUID.randomUUID(), "Playerthrower knockback resistance", Config.get().ELITE_AI.THROW_PLAYER_KNOCKBACK_RESISTANCE, 0));
        entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(UUID.randomUUID(), "Playerthrower health boost", Config.get().ELITE_AI.THROW_PLAYER_HEALTH_BOOST, 0));
    }

    public boolean func_75250_a() {
        return this.attackTime-- <= 0 && this.theEntity.func_70638_az() != null && this.theEntity.func_70638_az().field_70122_E && !this.theEntity.func_184218_aH() && this.theEntity.func_70681_au().nextInt(20) == 0 && this.findThrowTarget();
    }

    public void func_75249_e() {
        this.state = 1;
        this.extraGrabAttempts = this.theEntity.func_70681_au().nextInt(4);
        EntityLivingBase entity = this.theEntity.func_70638_az();
        if (entity != null) {
            this.theEntity.func_70661_as().func_75497_a((Entity)entity, 1.2);
        }
    }

    public boolean func_75253_b() {
        return this.state != 0 && this.theEntity.func_70638_az() != null && !this.theEntity.func_184218_aH() && this.throwTarget != null && this.throwTarget.func_70089_S();
    }

    public boolean func_75252_g() {
        return false;
    }

    public void func_75246_d() {
        if (this.state == 1) {
            EntityLivingBase target = this.theEntity.func_70638_az();
            if (target == null) {
                return;
            }
            this.theEntity.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            double range = this.theEntity.field_70130_N * 2.0f * this.theEntity.field_70130_N * 2.0f + target.field_70130_N;
            if (this.theEntity.func_70092_e(target.field_70165_t, target.func_174813_aQ().field_72338_b, target.field_70161_v) <= range) {
                target.func_184205_a((Entity)this.theEntity, true);
                this.theEntity.func_70661_as().func_75497_a((Entity)this.throwTarget, 1.3);
                this.theEntity.func_184609_a(EnumHand.MAIN_HAND);
                this.theEntity.func_184609_a(EnumHand.OFF_HAND);
                this.attackTime = 20;
                this.state = (byte)2;
            } else if (this.theEntity.func_70661_as().func_75500_f()) {
                this.theEntity.func_70661_as().func_75497_a((Entity)target, 1.2);
            }
        } else if (this.state == 2 && this.theEntity.func_184207_aI()) {
            this.theEntity.func_70671_ap().func_75651_a((Entity)this.throwTarget, 30.0f, 30.0f);
            if (this.attackTime-- <= 0 && this.theEntity.func_70681_au().nextInt(10) == 0 && this.theEntity.func_70068_e((Entity)this.throwTarget) <= 100.0) {
                double dX = this.throwTarget.field_70165_t - this.theEntity.field_70165_t;
                double dZ = this.throwTarget.field_70161_v - this.theEntity.field_70161_v;
                double dH = Math.sqrt(dX * dX + dZ * dZ);
                Entity entity = (Entity)this.theEntity.func_184188_bt().get(0);
                entity.func_184210_p();
                entity.field_70159_w = dX / dH + this.theEntity.field_70159_w * 0.2;
                entity.field_70179_y = dZ / dH + this.theEntity.field_70179_y * 0.2;
                entity.field_70181_x = 0.4;
                entity.field_70122_E = false;
                entity.field_70143_R = 0.0f;
                if (entity instanceof EntityPlayerMP) {
                    try {
                        ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(entity));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                this.theEntity.func_184609_a(EnumHand.MAIN_HAND);
                this.theEntity.func_184609_a(EnumHand.OFF_HAND);
                this.state = 0;
            } else if (this.theEntity.func_70661_as().func_75500_f()) {
                this.theEntity.func_70661_as().func_75497_a((Entity)this.throwTarget, 1.3);
            }
        } else if (this.extraGrabAttempts > 0) {
            --this.extraGrabAttempts;
            this.state = 1;
        } else {
            this.state = 0;
        }
        if (++this.giveUpDelay > 400) {
            this.state = 0;
        }
    }

    public void func_75251_c() {
        if (this.theEntity.func_184207_aI()) {
            ((Entity)this.theEntity.func_184188_bt().get(0)).func_184210_p();
        }
        this.theEntity.func_70661_as().func_75499_g();
        this.attackTime = 80 + this.theEntity.func_70681_au().nextInt(41);
        this.giveUpDelay = 0;
        this.throwTarget = null;
    }

    private boolean findThrowTarget() {
        EntityLivingBase target = this.theEntity.func_70638_az();
        if (target == null) {
            return false;
        }
        List list = this.theEntity.field_70170_p.func_72839_b((Entity)this.theEntity, target.func_174813_aQ().func_72321_a(16.0, 8.0, 16.0));
        int mostNearby = -1;
        for (Object obj : list) {
            EntityLiving entity;
            if (!(obj instanceof EntityLiving) || target != (entity = (EntityLiving)obj).func_70638_az()) continue;
            if (entity.func_70068_e((Entity)target) <= 9.0) {
                this.throwTarget = null;
                return false;
            }
            int nearby = entity.field_70170_p.func_72839_b((Entity)entity, entity.func_174813_aQ().func_72321_a(4.0, 1.0, 4.0)).size();
            if (nearby <= mostNearby) continue;
            mostNearby = nearby;
            this.throwTarget = entity;
        }
        return this.throwTarget != null;
    }
}

