/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.util;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class ModelUtil {
    private ModelUtil() {
    }

    public static void mapItemModel(Block block) {
        ModelUtil.mapItemModel(Item.func_150898_a((Block)block));
    }

    public static void mapItemModel(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName().toString(), "inventory"));
    }

    public static void mapItemModel(Item item, @Nonnull String customPath) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("foundry:" + customPath, "inventory"));
    }

    public static void mapItemVariantsModel(Block block, String suffix, IStringSerializable[] types) {
        ModelUtil.mapItemVariantsModel(Item.func_150898_a((Block)block), suffix, types);
    }

    public static void mapItemVariantsModel(Item item, String suffix, IStringSerializable[] types) {
        for (int i = 0; i < types.length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation("foundry:" + types[i].func_176610_l() + suffix, "inventory"));
        }
    }

    public static void mapFluidModel(BlockFluidBase fluidBlock) {
        Fluid fluid = fluidBlock.getFluid();
        FluidCustomModelMapper mapper = new FluidCustomModelMapper(fluid);
        ModelLoader.setCustomStateMapper((Block)fluidBlock, (IStateMapper)mapper);
        Item item = Item.func_150898_a((Block)fluidBlock);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mapper);
    }

    public static class FluidCustomModelMapper
    extends StateMapperBase
    implements ItemMeshDefinition {
        private final ModelResourceLocation res;

        public FluidCustomModelMapper(Fluid f) {
            this.res = new ModelResourceLocation("foundry:fluid", f.getName());
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            return this.res;
        }

        public ModelResourceLocation func_178132_a(IBlockState state) {
            return this.res;
        }
    }
}

