/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.util;

import exter.foundry.Foundry;
import exter.foundry.api.FoundryAPI;
import exter.foundry.api.FoundryUtils;
import exter.foundry.api.recipe.matcher.IItemMatcher;
import exter.foundry.api.recipe.matcher.ItemStackMatcher;
import exter.foundry.config.FoundryConfig;
import exter.foundry.item.ItemMold;
import exter.foundry.recipes.manager.CastingRecipeManager;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;

public class MiscUtil {
    public static int divCeil(int a, int b) {
        return a / b + (a % b == 0 ? 0 : 1);
    }

    public static FluidStack drainFluidFromWorld(World world, BlockPos pos, boolean do_drain) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof IFluidBlock) {
            IFluidBlock fluid_block = (IFluidBlock)state.func_177230_c();
            if (!fluid_block.canDrain(world, pos)) {
                return null;
            }
            return fluid_block.drain(world, pos, do_drain);
        }
        if (state.func_185904_a() == Material.field_151586_h && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            if (do_drain) {
                world.func_175698_g(pos);
            }
            return new FluidStack(FluidRegistry.WATER, 1000);
        }
        if (state.func_185904_a() == Material.field_151587_i && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            if (do_drain) {
                world.func_175698_g(pos);
            }
            return new FluidStack(FluidRegistry.LAVA, 1000);
        }
        return null;
    }

    public static Set<String> getAllItemOreDictionaryNames(ItemStack stack) {
        HashSet<String> result = new HashSet<String>();
        for (String name : OreDictionary.getOreNames()) {
            NonNullList<ItemStack> ores = MiscUtil.getOresSafe(name);
            for (ItemStack i : ores) {
                if (!i.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)i, (ItemStack)stack)) continue;
                result.add(name);
            }
        }
        return result;
    }

    public static String getItemOreDictionaryName(ItemStack stack) {
        for (String name : OreDictionary.getOreNames()) {
            NonNullList<ItemStack> ores = MiscUtil.getOresSafe(name);
            for (ItemStack i : ores) {
                if (!i.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)i, (ItemStack)stack)) continue;
                return name;
            }
        }
        return null;
    }

    public static ItemStack getModItemFromOreDictionary(String ore) {
        return MiscUtil.getModItemFromOreDictionary(ore, 1);
    }

    public static ItemStack getModItemFromOreDictionary(String ore, int amount) {
        return MiscUtil.getStackFromDictWithPreference(ore, amount);
    }

    public static NonNullList<ItemStack> getOresSafe(String ore) {
        return OreDictionary.getOres((String)ore, (boolean)false);
    }

    public static ItemStack getStackFromDictWithPreference(String ore, int amount) {
        ItemStack preferred = ItemStack.field_190927_a;
        int i = Integer.MAX_VALUE;
        block0: for (ItemStack item : MiscUtil.getOresSafe(ore)) {
            if (i == Integer.MAX_VALUE && preferred.func_190926_b()) {
                preferred = item;
            }
            String modid = item.func_77973_b().getCreatorModId(item);
            for (int j = 0; j <= Math.min(i, FoundryConfig.modPriority.length - 1); ++j) {
                if (!modid.equals(FoundryConfig.modPriority[j])) continue;
                i = j;
                preferred = item;
                if (i != 0) continue block0;
                break block0;
            }
        }
        if (!(preferred = ItemHandlerHelper.copyStackWithSize((ItemStack)preferred, (int)amount)).func_190926_b() && preferred.func_77960_j() == Short.MAX_VALUE) {
            preferred.func_77964_b(0);
        }
        return preferred;
    }

    public static boolean isInvalid(IItemMatcher matcher) {
        if (matcher == null) {
            Foundry.LOGGER.error("Null IItemMatcher! Instance: " + matcher);
            return true;
        }
        if (matcher.getItem().func_190926_b()) {
            Foundry.LOGGER.error("Invalid IItemMatcher with an empty match stack! Instance: " + matcher);
            return true;
        }
        if (matcher.getItems().isEmpty()) {
            Foundry.LOGGER.error("Invalid IItemMatcher with an empty match list! Instance: " + matcher);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void localizeTooltip(String key, List<String> tooltip) {
        String replaced = new TextComponentTranslation(key, new Object[0]).func_150260_c().replace("$CRUCIBLE_BASIC_MAX_TEMP", Integer.toString(FoundryAPI.CRUCIBLE_BASIC_MAX_TEMP / 100)).replace("$CRUCIBLE_STANDARD_MAX_TEMP", Integer.toString(FoundryAPI.CRUCIBLE_STANDARD_MAX_TEMP / 100)).replace("$CRUCIBLE_ADVANCED_MAX_TEMP", Integer.toString(FoundryAPI.CRUCIBLE_ADVANCED_MAX_TEMP / 100));
        for (String str : replaced.split("//")) {
            tooltip.add(TextFormatting.GRAY + str);
        }
    }

    public static void registerCasting(ItemStack item, Fluid liquid_metal, int amount, ItemMold.SubItem mold_meta) {
        MiscUtil.registerCasting(item, new FluidStack(liquid_metal, amount), mold_meta, null);
    }

    public static void registerCasting(ItemStack item, Fluid liquid_metal, int amount, ItemMold.SubItem mold_meta, IItemMatcher extra) {
        MiscUtil.registerCasting(item, new FluidStack(liquid_metal, amount), mold_meta, extra);
    }

    public static void registerCasting(ItemStack item, FluidStack fluid, ItemMold.SubItem mold_meta, @Nullable IItemMatcher extra) {
        MiscUtil.registerCasting(item, fluid, mold_meta, false, extra);
    }

    public static void registerCasting(ItemStack item, FluidStack fluid, ItemMold.SubItem mold_meta, boolean consume_mold, @Nullable IItemMatcher extra) {
        if (!item.func_190926_b()) {
            ItemStack extra_item;
            ItemStack itemStack = extra_item = extra != null ? extra.getItem() : ItemStack.field_190927_a;
            if (CastingRecipeManager.INSTANCE.findRecipe(new FluidStack(fluid.getFluid(), 6000), mold_meta, extra_item) == null) {
                CastingRecipeManager.INSTANCE.addRecipe((IItemMatcher)new ItemStackMatcher(item), fluid, mold_meta, consume_mold, extra);
            }
        } else {
            Foundry.LOGGER.error("Attempted to add a casting recipe with an invalid output!  Item: {}, Fluid: {}, Mold: {}, Extra: {}", (Object)item, (Object)fluid, (Object)mold_meta, (Object)extra);
        }
    }

    public static void registerInOreDictionary(String name, ItemStack stack) {
        if (!stack.func_190926_b() && !FoundryUtils.isItemInOreDictionary(name, stack)) {
            OreDictionary.registerOre((String)name, (ItemStack)stack);
        }
    }

    public static String upperCaseFirstChar(String s) {
        StringBuffer sb = new StringBuffer(s);
        for (int i = 0; i < sb.length() - 1; ++i) {
            if (i == 0) {
                sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
                continue;
            }
            if (sb.charAt(i) != '_') continue;
            sb.deleteCharAt(i);
            sb.setCharAt(i, Character.toUpperCase(sb.charAt(i)));
        }
        return sb.toString();
    }

    public static ItemStack parseItem(String id) {
        String lastPart;
        String[] parts = id.split(":");
        int length = parts.length;
        if (length == 0) {
            return ItemStack.field_190927_a;
        }
        int meta = 0;
        if (length > 1 && (lastPart = parts[length - 1]).matches("\\d+")) {
            --length;
            meta = Integer.parseInt(lastPart);
        }
        String realId = "";
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                realId = realId + ":";
            }
            realId = realId + parts[i];
        }
        try {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(realId));
            if (item != null) {
                return new ItemStack(item, 1, meta);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ItemStack.field_190927_a;
    }
}

