/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity;

import exter.foundry.tileentity.TileEntityFoundry;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;

@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2")
public abstract class TileEntityPowered
extends TileEntityFoundry
implements IEnergySink {
    protected final EnergyStorageMachine energyStorage = new EnergyStorageMachine(this.getFoundryEnergyCapacity(), 512, 0);
    public static int RATIO_RF = 1;
    public static int RATIO_EU = 4;
    private boolean added_enet = false;

    protected void onEnergyChanged() {
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing direction) {
        return true;
    }

    @Override
    public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
        if (cap == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyStorage);
        }
        return super.getCapability(cap, facing);
    }

    @Optional.Method(modid="ic2")
    public double getDemandedEnergy() {
        return (double)(this.getFoundryEnergyCapacity() - this.getStoredFoundryEnergy()) / (double)RATIO_EU;
    }

    public abstract int getFoundryEnergyCapacity();

    @Optional.Method(modid="ic2")
    public int getSinkTier() {
        return 1;
    }

    public int getStoredFoundryEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        if (cap == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(cap, facing);
    }

    @Optional.Method(modid="ic2")
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        double use_amount = Math.max(Math.min(amount, this.getDemandedEnergy()), 0.0);
        return amount - this.receiveEU(use_amount, true);
    }

    @Optional.Method(modid="ic2")
    public void loadEnet() {
        if (!this.added_enet && !this.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.added_enet = true;
        }
    }

    public void onChunkUnload() {
        if (Loader.isModLoaded((String)"ic2")) {
            this.unloadEnet();
        }
    }

    @Override
    protected void onInitialize() {
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("energy")) {
            this.energyStorage.setEnergy(compound.func_74762_e("energy"));
        }
    }

    private double receiveEU(double eu, boolean do_receive) {
        return (double)this.receiveFoundryEnergy((int)(eu * (double)RATIO_EU), do_receive) / (double)RATIO_EU;
    }

    private int receiveFoundryEnergy(int energy, boolean do_receive) {
        return this.energyStorage.receiveEnergy(energy, !do_receive);
    }

    @Optional.Method(modid="ic2")
    public void unloadEnet() {
        if (this.added_enet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.added_enet = false;
        }
    }

    @Override
    public void func_73660_a() {
        if (!this.added_enet) {
            try {
                ((Object)((Object)this)).getClass().getMethod("loadEnet", new Class[0]).invoke((Object)this, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                if (Loader.isModLoaded((String)"ic2")) {
                    throw new RuntimeException(e);
                }
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        super.func_73660_a();
    }

    @Override
    public void updateRedstone() {
        this.redstone_signal = this.field_145850_b.func_175687_A(this.func_174877_v()) > 0;
    }

    @Override
    protected void updateServer() {
    }

    public int useFoundryEnergy(int amount, boolean do_use) {
        return this.energyStorage.useEnergy(amount, !do_use);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("energy", this.energyStorage.getEnergyStored());
        return super.func_189515_b(compound);
    }

    private class EnergyStorageMachine
    extends EnergyStorage {
        public EnergyStorageMachine(int capacity, int maxReceive, int maxExtract) {
            super(capacity, maxReceive, maxExtract);
        }

        public void setEnergy(int energy) {
            this.energy = Math.min(energy, this.getMaxEnergyStored());
            TileEntityPowered.this.onEnergyChanged();
        }

        public int useEnergy(int maxExtract, boolean simulate) {
            int energyExtracted = Math.min(this.energy, maxExtract);
            if (!simulate && energyExtracted != 0) {
                this.energy -= energyExtracted;
                TileEntityPowered.this.onEnergyChanged();
            }
            return energyExtracted;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int ret = super.extractEnergy(maxExtract, simulate);
            if (!simulate && ret != 0) {
                TileEntityPowered.this.onEnergyChanged();
            }
            return ret;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int ret = super.receiveEnergy(maxReceive, simulate);
            if (!simulate && ret != 0) {
                TileEntityPowered.this.onEnergyChanged();
            }
            return ret;
        }
    }
}

