/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity;

import exter.foundry.api.recipe.IMoldRecipe;
import exter.foundry.api.recipe.matcher.OreMatcher;
import exter.foundry.block.BlockMoldStation;
import exter.foundry.item.FoundryItems;
import exter.foundry.recipes.manager.MoldRecipeManager;
import exter.foundry.tileentity.TileEntityFoundry;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.Optional;
import vazkii.botania.api.item.IExoflameHeatable;

@Optional.Interface(iface="vazkii.botania.api.item.IExoflameHeatable", modid="Botania")
public class TileEntityMoldStation
extends TileEntityFoundry
implements IExoflameHeatable {
    public static final int SLOT_BLOCK = 0;
    public static final int SLOT_CLAY = 1;
    public static final int SLOT_OUTPUT = 2;
    public static final int SLOT_FUEL = 3;
    public static final int MIN_DEPTH = 0;
    public static final int MAX_DEPTH = 4;
    public static final OreMatcher CLAYBLOCK_MATCHER = new OreMatcher("foundryClayblock");
    private int burn_time = 0;
    private int item_burn_time = 0;
    private int progress = 0;
    private boolean has_block = false;
    private boolean update_burn_times = false;
    private final int[] grid = new int[36];
    private IMoldRecipe current_recipe = null;

    @Optional.Method(modid="Botania")
    public void boostBurnTime() {
        if (!this.field_145850_b.field_72995_K) {
            this.burn_time = 200;
            this.item_burn_time = 199;
            this.update_burn_times = true;
            this.func_70296_d();
        }
    }

    @Optional.Method(modid="Botania")
    public void boostCookTime() {
    }

    public boolean canInsertItem(int par1, ItemStack par2ItemStack, EnumFacing side) {
        return this.func_94041_b(par1, par2ItemStack);
    }

    private boolean canOutput(ItemStack output, int slot) {
        ItemStack inv_output = this.func_70301_a(slot);
        if (inv_output.func_190926_b()) {
            return true;
        }
        return inv_output.func_77969_a(output) && inv_output.func_190916_E() - output.func_190916_E() <= inv_output.func_77976_d();
    }

    private boolean canRecipeOutput() {
        ItemStack output = this.current_recipe.getOutput();
        int clay_amount = this.getCarvedClayAmount();
        ItemStack slot_clay = this.func_70301_a(1);
        return this.canOutput(output, 2) && (slot_clay.func_190926_b() || slot_clay.func_190916_E() + clay_amount <= slot_clay.func_77976_d());
    }

    @Optional.Method(modid="Botania")
    public boolean canSmelt() {
        return this.has_block && this.current_recipe != null && this.canRecipeOutput();
    }

    public void carve(NonNullList<Boolean> pattern, int depth) {
        if (this.field_145850_b.field_72995_K && this.has_block && pattern.size() == this.grid.length) {
            NBTTagCompound tag = new NBTTagCompound();
            for (int i = 0; i < this.grid.length; ++i) {
                int depthNew;
                if (pattern.get(i) != Boolean.TRUE || (depthNew = MathHelper.func_76125_a((int)(depth + this.grid[i]), (int)0, (int)4)) == this.grid[i]) continue;
                this.grid[i] = depthNew;
                tag.func_74768_a("RecipeGrid_" + i, this.grid[i]);
            }
            this.sendToServer(tag);
        }
    }

    private void clearGrid() {
        for (int i = 0; i < 36; ++i) {
            if (this.grid[i] <= 0) continue;
            this.grid[i] = 0;
        }
        this.current_recipe = null;
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
    }

    private void doSmelt() {
        if (!this.canRecipeOutput()) {
            this.progress = 0;
            return;
        }
        ItemStack output = this.current_recipe.getOutput();
        int clay = this.getCarvedClayAmount();
        if (++this.progress == 200) {
            this.progress = 0;
            if (this.func_70301_a(2).func_190926_b()) {
                this.setStackInSlot(2, output.func_77946_l());
            } else {
                this.func_70301_a(2).func_190917_f(output.func_190916_E());
            }
            if (this.func_70301_a(1).func_190926_b()) {
                this.setStackInSlot(1, new ItemStack(FoundryItems.item_small_clay, clay));
            } else {
                this.func_70301_a(1).func_190917_f(clay);
            }
            this.updateInventoryItem(2);
            this.updateInventoryItem(1);
            this.has_block = false;
            this.clearGrid();
        }
    }

    public void fire() {
        if (this.field_145850_b.field_72995_K) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a("command_fire", true);
            this.sendToServer(tag);
        }
    }

    public int getBurningTime() {
        return this.burn_time;
    }

    @Optional.Method(modid="Botania")
    public int getBurnTime() {
        return this.burn_time <= 1 ? 0 : this.burn_time - 1;
    }

    private int getCarvedClayAmount() {
        int amount = 0;
        for (int g : this.grid) {
            amount += g;
        }
        return amount / 10;
    }

    public int getGridSlot(int slot) {
        return this.grid[slot];
    }

    public int getItemBurnTime() {
        return this.item_burn_time;
    }

    public int getProgress() {
        return this.progress;
    }

    public int func_70302_i_() {
        return 4;
    }

    @Override
    public FluidTank getTank(int slot) {
        return null;
    }

    @Override
    public int getTankCount() {
        return 0;
    }

    public boolean hasBlock() {
        return this.has_block;
    }

    public boolean isBurning() {
        return this.burn_time > 0;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                return CLAYBLOCK_MATCHER.test(stack);
            }
            case 3: {
                return TileEntityFurnace.func_145954_b((ItemStack)stack);
            }
        }
        return false;
    }

    public void mend(NonNullList<Boolean> pattern, int depth) {
        this.carve(pattern, -depth);
    }

    @Override
    protected void onInitialize() {
        this.current_recipe = null;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("BurnTime")) {
            this.burn_time = tag.func_74762_e("BurnTime");
        }
        if (tag.func_74764_b("CookTime")) {
            this.progress = tag.func_74762_e("CookTime");
        }
        if (tag.func_74764_b("ItemBurnTime")) {
            this.item_burn_time = tag.func_74762_e("ItemBurnTime");
        }
        boolean grid_changed = false;
        for (int i = 0; i < 36; ++i) {
            if (!tag.func_74764_b("RecipeGrid_" + i)) continue;
            this.grid[i] = tag.func_74762_e("RecipeGrid_" + i);
            grid_changed = true;
        }
        if (tag.func_74764_b("HasBlock")) {
            this.has_block = tag.func_74767_n("HasBlock");
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.has_block) {
            if (grid_changed) {
                this.current_recipe = null;
            }
            if (tag.func_74764_b("command_fire")) {
                this.current_recipe = MoldRecipeManager.INSTANCE.findRecipe(this.grid);
            }
            ((BlockMoldStation)this.func_145838_q()).setMachineState(this.field_145850_b, this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.burn_time > 0);
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    protected void updateClient() {
    }

    @Override
    protected void updateServer() {
        ItemStack block;
        int last_burn_time = this.burn_time;
        int last_progress = this.progress;
        int last_item_burn_time = this.item_burn_time;
        if (!this.has_block && !(block = this.func_70301_a(0)).func_190926_b()) {
            this.func_70298_a(0, 1);
            this.has_block = true;
            this.clearGrid();
        }
        if (this.burn_time > 0) {
            --this.burn_time;
        }
        if (this.has_block && this.progress >= 0) {
            if (this.burn_time == 0 && this.current_recipe != null && this.canRecipeOutput()) {
                this.item_burn_time = this.burn_time = TileEntityFurnace.func_145952_a((ItemStack)this.func_70301_a(3));
                if (this.burn_time > 0 && !this.func_70301_a(3).func_190926_b()) {
                    this.func_70301_a(3).func_190918_g(1);
                    if (this.func_70301_a(3).func_190916_E() == 0) {
                        this.setStackInSlot(3, this.func_70301_a(3).func_77973_b().getContainerItem(this.func_70301_a(3)));
                    }
                    this.updateInventoryItem(3);
                }
            }
            if (this.burn_time > 0) {
                if (this.current_recipe != null) {
                    this.doSmelt();
                } else {
                    this.progress = 0;
                }
            } else {
                this.progress = 0;
            }
        }
        if ((last_burn_time != this.burn_time || this.update_burn_times) && last_burn_time * this.burn_time == 0) {
            ((BlockMoldStation)this.func_145838_q()).setMachineState(this.field_145850_b, this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.burn_time > 0);
        }
        this.update_burn_times = false;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", this.burn_time);
        compound.func_74768_a("CookTime", this.progress);
        compound.func_74768_a("ItemBurnTime", this.item_burn_time);
        for (int i = 0; i < 36; ++i) {
            compound.func_74768_a("RecipeGrid_" + i, this.grid[i]);
        }
        compound.func_74757_a("HasBlock", this.has_block);
        return compound;
    }
}

