/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity;

import com.google.common.collect.ImmutableSet;
import exter.foundry.api.recipe.IInfuserRecipe;
import exter.foundry.recipes.manager.InfuserRecipeManager;
import exter.foundry.tileentity.TileEntityFoundry;
import exter.foundry.tileentity.TileEntityPowered;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityMetalInfuser
extends TileEntityPowered {
    public static final int INVENTORY_SUBSTANCE_INPUT = 0;
    public static final int INVENTORY_CONTAINER_INPUT_INPUT = 1;
    public static final int INVENTORY_CONTAINER_INPUT_OUTPUT = 2;
    public static final int INVENTORY_CONTAINER_OUTPUT_INPUT = 3;
    public static final int INVENTORY_CONTAINER_OUTPUT_OUTPUT = 4;
    public static final int TANK_INPUT = 0;
    public static final int TANK_OUTPUT = 1;
    private static final Set<Integer> IH_SLOTS_INPUT = ImmutableSet.of((Object)0);
    private static final Set<Integer> IH_SLOTS_OUTPUT = ImmutableSet.of();
    private final FluidTank[] tanks = new FluidTank[2];
    private final IFluidHandler fluid_handler;
    private final TileEntityFoundry.ItemHandler item_handler;
    private int progress;
    private int extract_energy;
    private IInfuserRecipe current_recipe;

    public TileEntityMetalInfuser() {
        this.tanks[0] = new FluidTank(5000);
        this.tanks[1] = new FluidTank(5000);
        this.fluid_handler = new TileEntityFoundry.FluidHandler(0, 1);
        this.item_handler = new TileEntityFoundry.ItemHandler(this.func_70302_i_(), IH_SLOTS_INPUT, IH_SLOTS_OUTPUT);
        this.progress = 0;
        this.extract_energy = 1;
        this.current_recipe = null;
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(0, 1, 2, false));
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(1, 3, 4, false));
    }

    private void checkCurrentRecipe() {
        if (this.current_recipe == null) {
            this.progress = 0;
            this.extract_energy = 1;
            return;
        }
        if (!this.current_recipe.matchesRecipe(this.getTank(0).getFluid(), this.func_70301_a(0))) {
            this.progress = 0;
            this.extract_energy = 1;
            this.current_recipe = null;
            return;
        }
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
    }

    private void doInfusion() {
        FluidStack output = this.current_recipe.getOutput();
        this.extract_energy = this.current_recipe.getEnergyNeeded();
        if (this.fillTank(1, output, false) < output.amount) {
            this.progress = 0;
            return;
        }
        if (this.getStoredFoundryEnergy() > 0) {
            int needed = this.extract_energy - this.progress;
            if (needed > 200) {
                needed = 200;
            }
            long energy = this.useFoundryEnergy(needed, true);
            this.progress = (int)((long)this.progress + energy);
            if (this.progress >= this.extract_energy) {
                this.progress = 0;
                this.drainTank(0, this.current_recipe.getInputFluid(), true);
                this.fillTank(1, output, true);
                this.func_70298_a(0, 1);
            }
        }
    }

    public int getExtractTime() {
        return this.extract_energy;
    }

    @Override
    protected IFluidHandler getFluidHandler(EnumFacing facing) {
        return this.fluid_handler;
    }

    @Override
    protected IItemHandler getItemHandler(EnumFacing side) {
        return this.item_handler;
    }

    public int getProgress() {
        return this.progress;
    }

    public int func_70302_i_() {
        return 5;
    }

    @Override
    public FluidTank getTank(int slot) {
        return this.tanks[slot];
    }

    @Override
    public int getTankCount() {
        return 2;
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return true;
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
    }

    @Override
    public void func_145839_a(NBTTagCompound compund) {
        super.func_145839_a(compund);
        if (compund.func_74764_b("progress")) {
            this.progress = compund.func_74762_e("progress");
        }
        if (compund.func_74764_b("extract_time")) {
            this.extract_energy = compund.func_74762_e("extract_time");
        }
    }

    @Override
    protected void updateClient() {
    }

    @Override
    protected void updateServer() {
        super.updateServer();
        int last_progress = this.progress;
        int last_extract_time = this.extract_energy;
        this.checkCurrentRecipe();
        if (this.current_recipe == null) {
            this.current_recipe = InfuserRecipeManager.INSTANCE.findRecipe(this.tanks[0].getFluid(), this.func_70301_a(0));
            this.progress = 0;
        }
        if (this.current_recipe != null) {
            this.doInfusion();
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("progress", this.progress);
        compound.func_74768_a("extract_time", this.extract_energy);
        return compound;
    }

    @Override
    public int getFoundryEnergyCapacity() {
        return 3000;
    }
}

