/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity;

import com.google.common.collect.ImmutableSet;
import exter.foundry.api.recipe.ICastingRecipe;
import exter.foundry.config.FoundryConfig;
import exter.foundry.recipes.manager.CastingRecipeManager;
import exter.foundry.tileentity.TileEntityFoundry;
import exter.foundry.tileentity.TileEntityPowered;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityMetalCaster
extends TileEntityPowered {
    public static final int ENERGY_REQUIRED = FoundryConfig.metalCasterPower ? 10000 : 0;
    public static final int INVENTORY_OUTPUT = 0;
    public static final int INVENTORY_MOLD = 1;
    public static final int INVENTORY_EXTRA = 2;
    public static final int INVENTORY_CONTAINER_INPUT = 3;
    public static final int INVENTORY_CONTAINER_OUTPUT = 4;
    public static final int INVENTORY_MOLD_STORAGE = 5;
    public static final int INVENTORY_MOLD_STORAGE_SIZE = 9;
    private static final Set<Integer> IH_SLOTS_INPUT = ImmutableSet.of((Object)2);
    private static final Set<Integer> IH_SLOTS_OUTPUT = ImmutableSet.of((Object)0);
    private final FluidTank tank = new FluidTank(6000);
    private final IFluidHandler fluid_handler = new TileEntityFoundry.FluidHandler(0, 0);
    private final TileEntityFoundry.ItemHandler item_handler = new TileEntityFoundry.ItemHandler(this.func_70302_i_(), IH_SLOTS_INPUT, IH_SLOTS_OUTPUT);
    private ICastingRecipe currentRecipe = null;
    private int progress;
    private int totalTick;

    public TileEntityMetalCaster() {
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(0, 3, 4, false));
    }

    private void beginCasting() {
        if (this.currentRecipe != null && this.canCastCurrentRecipe() && (!FoundryConfig.metalCasterPower || this.getStoredFoundryEnergy() >= ENERGY_REQUIRED)) {
            if (FoundryConfig.metalCasterPower) {
                this.useFoundryEnergy(ENERGY_REQUIRED, true);
            }
            this.totalTick = this.progress = this.currentRecipe.getCastingTime();
        }
    }

    private boolean canCastCurrentRecipe() {
        if (this.currentRecipe.requiresExtra() && !this.currentRecipe.containsExtra((ItemStack)this.inventory.get(2))) {
            return false;
        }
        ItemStack recipe_output = this.currentRecipe.getOutput();
        ItemStack inv_output = (ItemStack)this.inventory.get(0);
        return inv_output.func_190926_b() || inv_output.func_77969_a(recipe_output) && inv_output.func_190916_E() + recipe_output.func_190916_E() <= inv_output.func_77976_d();
    }

    private void checkCurrentRecipe() {
        if (this.currentRecipe == null) {
            this.progress = -1;
            this.totalTick = -1;
            return;
        }
        if (!this.currentRecipe.matchesRecipe((ItemStack)this.inventory.get(1), this.tank.getFluid(), (ItemStack)this.inventory.get(2))) {
            this.progress = -1;
            this.totalTick = -1;
            this.currentRecipe = null;
            return;
        }
    }

    @Override
    protected IFluidHandler getFluidHandler(EnumFacing facing) {
        return this.fluid_handler;
    }

    @Override
    protected IItemHandler getItemHandler(EnumFacing side) {
        return this.item_handler;
    }

    public int getProgress() {
        return this.progress;
    }

    public int func_70302_i_() {
        return 14;
    }

    @Override
    public FluidTank getTank(int slot) {
        if (slot != 0) {
            return null;
        }
        return this.tank;
    }

    @Override
    public int getTankCount() {
        return 1;
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return slot == 2;
    }

    @Override
    public void func_145839_a(NBTTagCompound compund) {
        super.func_145839_a(compund);
        if (compund.func_74764_b("progress")) {
            this.progress = compund.func_74762_e("progress");
        }
        if (compund.func_74764_b("total")) {
            this.totalTick = compund.func_74762_e("total");
        }
    }

    @Override
    protected void updateClient() {
    }

    @Override
    protected void updateServer() {
        super.updateServer();
        int last_progress = this.progress;
        this.checkCurrentRecipe();
        if (this.currentRecipe == null) {
            this.currentRecipe = CastingRecipeManager.INSTANCE.findRecipe(this.tank.getFluid(), (ItemStack)this.inventory.get(1), (ItemStack)this.inventory.get(2));
            this.progress = -1;
            this.totalTick = -1;
        }
        if (this.progress < 0) {
            switch (this.getRedstoneMode()) {
                case RSMODE_IGNORE: {
                    this.beginCasting();
                    break;
                }
                case RSMODE_OFF: {
                    if (this.redstone_signal) break;
                    this.beginCasting();
                    break;
                }
                case RSMODE_ON: {
                    if (!this.redstone_signal) break;
                    this.beginCasting();
                    break;
                }
                case RSMODE_PULSE: {
                    if (!this.redstone_signal || this.last_redstone_signal) break;
                    this.beginCasting();
                }
            }
        } else if (this.canCastCurrentRecipe()) {
            --this.progress;
            if (this.progress == 0) {
                this.progress = -1;
                this.totalTick = -1;
                this.tank.drain(this.currentRecipe.getInput().amount, true);
                if (this.currentRecipe.requiresExtra()) {
                    this.func_70298_a(2, this.currentRecipe.getInputExtra().getAmount());
                    this.updateInventoryItem(2);
                }
                if (((ItemStack)this.inventory.get(0)).func_190926_b()) {
                    this.inventory.set(0, (Object)this.currentRecipe.getOutput());
                } else {
                    ((ItemStack)this.inventory.get(0)).func_190917_f(this.currentRecipe.getOutput().func_190916_E());
                }
                if (this.currentRecipe.consumesMold()) {
                    ((ItemStack)this.inventory.get(1)).func_190918_g(1);
                }
                this.updateInventoryItem(0);
                this.updateTank(0);
                this.func_70296_d();
            }
        } else {
            this.progress = -1;
            this.totalTick = -1;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("progress", this.progress);
        compound.func_74768_a("total", this.totalTick);
        return super.func_189515_b(compound);
    }

    @Override
    public int getFoundryEnergyCapacity() {
        return 40000;
    }

    public int getTotalTick() {
        return this.totalTick;
    }

    @Override
    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        if (cap == CapabilityEnergy.ENERGY) {
            return FoundryConfig.metalCasterPower;
        }
        return super.hasCapability(cap, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
        if (!FoundryConfig.metalCasterPower && cap == CapabilityEnergy.ENERGY) {
            return null;
        }
        return super.getCapability(cap, facing);
    }
}

