/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity;

import com.google.common.collect.ImmutableSet;
import exter.foundry.api.FoundryAPI;
import exter.foundry.api.recipe.IMeltingRecipe;
import exter.foundry.recipes.manager.MeltingRecipeManager;
import exter.foundry.tileentity.TileEntityFoundry;
import exter.foundry.tileentity.TileEntityHeatable;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityMeltingCrucibleBasic
extends TileEntityHeatable {
    public static final int SMELT_TIME = 5000000;
    public static final int INVENTORY_INPUT = 0;
    public static final int INVENTORY_CONTAINER_INPUT = 1;
    public static final int INVENTORY_CONTAINER_OUTPUT = 2;
    private static final Set<Integer> IH_SLOTS_INPUT = ImmutableSet.of((Object)0);
    private static final Set<Integer> IH_SLOTS_OUTPUT = ImmutableSet.of();
    private final FluidTank tank = new FluidTank(6000);
    private final IFluidHandler fluid_handler = new TileEntityFoundry.FluidHandler(-1, 0);
    private final TileEntityFoundry.ItemHandler item_handler = new TileEntityFoundry.ItemHandler(this.func_70302_i_(), IH_SLOTS_INPUT, IH_SLOTS_OUTPUT);
    private int progress = 0;
    private int melt_point = 0;
    private IMeltingRecipe current_recipe = null;

    public TileEntityMeltingCrucibleBasic() {
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(0, 1, 2, false));
    }

    @Override
    protected boolean canReceiveHeat() {
        boolean active = true;
        switch (this.getRedstoneMode()) {
            case RSMODE_OFF: {
                if (!this.redstone_signal) break;
                active = false;
                break;
            }
            case RSMODE_ON: {
                if (this.redstone_signal) break;
                active = false;
                break;
            }
        }
        return active;
    }

    private void checkCurrentRecipe() {
        if (this.current_recipe == null) {
            this.progress = 0;
            return;
        }
        if (!this.current_recipe.matchesRecipe((ItemStack)this.inventory.get(0))) {
            this.progress = 0;
            this.current_recipe = null;
        }
    }

    private void doMeltingProgress() {
        if (this.current_recipe == null) {
            this.progress = 0;
            this.melt_point = 0;
            return;
        }
        FluidStack fs = this.current_recipe.getOutput();
        this.melt_point = this.current_recipe.getMeltingPoint() * 100;
        int heat = this.getTemperature();
        if (heat <= this.melt_point || this.tank.fill(fs, false) < fs.amount) {
            this.progress = 0;
            return;
        }
        int increment = (heat - this.melt_point) * 5 * this.current_recipe.getMeltingSpeed() / (fs.amount * 4);
        if (increment < 1) {
            increment = 1;
        }
        if (increment > 1250000) {
            increment = 1250000;
        }
        this.progress += increment;
        if (this.progress >= 5000000) {
            this.progress = 0;
            this.tank.fill(fs, true);
            this.func_70298_a(0, this.current_recipe.getInput().getAmount());
            this.updateTank(0);
        }
    }

    @Override
    protected IFluidHandler getFluidHandler(EnumFacing facing) {
        return this.fluid_handler;
    }

    @Override
    protected IItemHandler getItemHandler(EnumFacing side) {
        return this.item_handler;
    }

    @Override
    public int getMaxTemperature() {
        return FoundryAPI.CRUCIBLE_BASIC_MAX_TEMP;
    }

    public int getMeltingPoint() {
        return this.melt_point;
    }

    public int getProgress() {
        return this.progress;
    }

    public int func_70302_i_() {
        return 3;
    }

    @Override
    public FluidTank getTank(int slot) {
        if (slot != 0) {
            return null;
        }
        return this.tank;
    }

    @Override
    public int getTankCount() {
        return 1;
    }

    @Override
    public int getTemperatureLossRate() {
        return FoundryAPI.CRUCIBLE_BASIC_TEMP_LOSS_RATE;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == 0;
    }

    @Override
    protected void onInitialize() {
    }

    @Override
    public void func_145839_a(NBTTagCompound compund) {
        super.func_145839_a(compund);
        if (compund.func_74764_b("progress")) {
            this.progress = compund.func_74762_e("progress");
        }
        if (compund.func_74764_b("melt_point")) {
            this.melt_point = compund.func_74762_e("melt_point");
        }
    }

    @Override
    protected void updateClient() {
    }

    @Override
    protected void updateServer() {
        super.updateServer();
        int last_progress = this.progress;
        int last_melt_point = this.melt_point;
        this.checkCurrentRecipe();
        if (this.current_recipe == null) {
            this.current_recipe = MeltingRecipeManager.INSTANCE.findRecipe((ItemStack)this.inventory.get(0));
        }
        this.doMeltingProgress();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("melt_point", this.melt_point);
        compound.func_74768_a("progress", this.progress);
        return compound;
    }
}

