/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity;

import com.google.common.collect.ImmutableSet;
import exter.foundry.tileentity.TileEntityFoundry;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.IItemHandler;

public class TileEntityMaterialRouter
extends TileEntityFoundry {
    public static final int SLOT_OUTPUT = 3;
    private static final Set<Integer> IH_SLOTS_INPUT = ImmutableSet.of((Object)0, (Object)1, (Object)2);
    private final List<Route> routes = new ArrayList<Route>();
    private int input_index = 0;
    public int gui_material_scroll = 0;
    public int gui_type_scroll = 0;
    public int gui_route_scroll = 0;
    public int gui_material_selected = 0;
    public int gui_type_selected = 0;
    private final Map<EnumFacing, TileEntityFoundry.ItemHandler> item_handlers = new EnumMap<EnumFacing, TileEntityFoundry.ItemHandler>(EnumFacing.class);

    public TileEntityMaterialRouter() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.item_handlers.put(facing, new TileEntityFoundry.ItemHandler(this.func_70302_i_(), IH_SLOTS_INPUT, (Set<Integer>)ImmutableSet.of((Object)(3 + facing.func_176745_a()))));
        }
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.syncRoutes();
        }
    }

    @Override
    protected IItemHandler getItemHandler(EnumFacing side) {
        if (side == null) {
            return null;
        }
        return (IItemHandler)this.item_handlers.get(side);
    }

    public List<Route> getRoutes() {
        return this.routes;
    }

    public int func_70302_i_() {
        return 9;
    }

    @Override
    public FluidTank getTank(int slot) {
        return null;
    }

    @Override
    public int getTankCount() {
        return 0;
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        return slot < 3;
    }

    @Override
    protected void onInitialize() {
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.syncRoutes();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
    }

    private void routeItem(int in_slot, int out_slot) {
        ItemStack input = (ItemStack)this.inventory.get(in_slot);
        ItemStack output = (ItemStack)this.inventory.get(out_slot);
        if (output.func_190926_b()) {
            this.inventory.set(out_slot, (Object)input);
            this.inventory.set(in_slot, (Object)ItemStack.field_190927_a);
            this.updateInventoryItem(in_slot);
            this.updateInventoryItem(out_slot);
        } else {
            if (!output.func_77969_a(input) || !ItemStack.func_77970_a((ItemStack)output, (ItemStack)input)) {
                return;
            }
            int transfer = output.func_77976_d() - output.func_190916_E();
            if (transfer > input.func_190916_E()) {
                transfer = input.func_190916_E();
            }
            this.func_70298_a(in_slot, transfer);
            ((ItemStack)this.inventory.get(out_slot)).func_190917_f(transfer);
            this.updateInventoryItem(in_slot);
            this.updateInventoryItem(out_slot);
        }
    }

    public void syncRoutes() {
    }

    @Override
    protected void updateClient() {
    }

    @Override
    protected void updateServer() {
        int i;
        ItemStack input;
        if (this.input_index % 4 == 0 && !(input = (ItemStack)this.inventory.get(i = this.input_index / 4)).func_190926_b()) {
            for (Route r : this.routes) {
                if (!r.matchesItem(input)) continue;
                this.routeItem(i, 3 + r.side.func_176745_a());
                break;
            }
        }
        this.input_index = (this.input_index + 1) % 12;
    }

    private void writeRoutesToNBT(NBTTagCompound compound) {
        NBTTagCompound routes_tag = new NBTTagCompound();
        routes_tag.func_74768_a("size", this.routes.size());
        for (int i = 0; i < this.routes.size(); ++i) {
            NBTTagCompound route_entry_tag = new NBTTagCompound();
            this.routes.get(i).writeToNBT(route_entry_tag);
            routes_tag.func_74782_a("Route_" + String.valueOf(i), (NBTBase)route_entry_tag);
        }
        compound.func_74782_a("Routes", (NBTBase)routes_tag);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        return compound;
    }

    public static class Route {
        public String material;
        public String type;
        public EnumFacing side;

        public Route(ByteBuf data) {
            this.material = ByteBufUtils.readUTF8String((ByteBuf)data);
            this.type = ByteBufUtils.readUTF8String((ByteBuf)data);
            this.side = EnumFacing.values()[data.readByte()];
        }

        public Route(NBTTagCompound tag) {
            this.readFromNBT(tag);
        }

        public Route(String route_material, String route_type, EnumFacing route_side) {
            this.material = route_material;
            this.type = route_type;
            this.side = route_side;
        }

        public boolean matchesItem(ItemStack stack) {
            return true;
        }

        public void readFromNBT(NBTTagCompound tag) {
            this.material = tag.func_74779_i("material");
            this.type = tag.func_74779_i("type");
            this.side = EnumFacing.field_82609_l[tag.func_74771_c("side")];
        }

        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74778_a("material", this.material);
            tag.func_74778_a("type", this.type);
            tag.func_74774_a("side", (byte)this.side.func_176745_a());
        }

        public void writeToPacket(ByteBuf data) {
            ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.material);
            ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.type);
            data.writeByte(this.side.func_176745_a());
        }
    }
}

