/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity;

import exter.foundry.api.FoundryAPI;
import exter.foundry.api.heatable.IHeatProvider;
import exter.foundry.tileentity.TileEntityFoundry;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;

public abstract class TileEntityHeatable
extends TileEntityFoundry {
    public static final int TEMP_MIN = 30000;
    private final int MAX_HEAT_RECEIVE = TileEntityHeatable.getStableTemperatureNeed(this.getMaxTemperature(), this.getTemperatureLossRate()) - this.getMaxTemperature();
    private int heat = 30000;
    public static final Object2IntMap<IBlockState> STATE_SOURCES = new Object2IntOpenHashMap();

    public static int getStableTemperatureNeed(int temperature, int loss_rate) {
        return Math.floorDiv(temperature * loss_rate - 30000, loss_rate - 1);
    }

    protected abstract boolean canReceiveHeat();

    private final IHeatProvider getHeatProvider() {
        TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b());
        if (te != null && te.hasCapability(FoundryAPI.HEAT_PROVIDER_CAP, EnumFacing.UP)) {
            return (IHeatProvider)te.getCapability(FoundryAPI.HEAT_PROVIDER_CAP, EnumFacing.UP);
        }
        return null;
    }

    @Override
    protected void updateServer() {
        int temp_max = this.getMaxTemperature();
        int temp_last = this.heat;
        if (this.canReceiveHeat()) {
            IHeatProvider heater = this.getHeatProvider();
            int temp_heater = 0;
            if (heater != null) {
                temp_heater = Math.max(0, heater.provideHeat(temp_max, temp_last));
            } else if (!STATE_SOURCES.isEmpty()) {
                IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b());
                temp_heater = STATE_SOURCES.getInt((Object)state);
            }
            if (temp_heater > 0) {
                int receive = this.getHeatReceive(temp_heater);
                this.heat += receive;
            }
        }
        this.heat -= this.getTemperatureLoss(temp_last);
        this.heat = MathHelper.func_76125_a((int)this.heat, (int)30000, (int)temp_max);
    }

    private int getHeatReceive(int temp_heater) {
        if (this.heat > temp_heater) {
            return 0;
        }
        return Math.min(this.MAX_HEAT_RECEIVE, this.getTemperatureLoss(temp_heater));
    }

    public int getTemperatureLoss(int heat) {
        return (heat - 30000) / this.getTemperatureLossRate();
    }

    public abstract int getMaxTemperature();

    public abstract int getTemperatureLossRate();

    public final int getTemperature() {
        return this.heat;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("heat", this.heat);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compund) {
        super.func_145839_a(compund);
        if (compund.func_150297_b("heat", 3)) {
            this.heat = MathHelper.func_76125_a((int)compund.func_74762_e("heat"), (int)30000, (int)this.getMaxTemperature());
        }
    }
}

