/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity;

import com.google.common.collect.ImmutableSet;
import exter.foundry.Foundry;
import exter.foundry.network.MessageTileEntitySync;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankPropertiesWrapper;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileEntityFoundry
extends TileEntity
implements ITickable,
IInventory,
ICapabilityProvider {
    private RedstoneMode mode;
    private final List<ContainerSlot> conatiner_slots = new ArrayList<ContainerSlot>(5);
    private boolean initialized = false;
    protected boolean last_redstone_signal = false;
    protected boolean redstone_signal = false;
    protected final NonNullList<ItemStack> inventory;
    private int container_timer = 0;

    public TileEntityFoundry() {
        this.mode = RedstoneMode.RSMODE_IGNORE;
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    protected final void addContainerSlot(ContainerSlot cs) {
        this.conatiner_slots.add(cs);
    }

    public void func_174888_l() {
    }

    public void func_174886_c(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K && player instanceof EntityPlayerMP) {
            NBTTagCompound tag = new NBTTagCompound();
            super.func_189515_b(tag);
            tag.func_74768_a("rsmode", this.mode.id);
            this.sendPacketToPlayer(tag, (EntityPlayerMP)player);
        }
    }

    public final ItemStack func_70298_a(int slot, int amount) {
        if (!this.func_70301_a(slot).func_190926_b()) {
            if (this.func_70301_a(slot).func_190916_E() <= amount) {
                ItemStack is = this.func_70301_a(slot);
                this.setStackInSlot(slot, ItemStack.field_190927_a);
                this.updateInventoryItem(slot);
                return is;
            }
            ItemStack is = this.func_70301_a(slot).func_77979_a(amount);
            this.updateInventoryItem(slot);
            return is;
        }
        return ItemStack.field_190927_a;
    }

    protected final FluidStack drainTank(int slot, FluidStack resource, boolean doDrain) {
        FluidTank tank = this.getTank(slot);
        if (resource.isFluidEqual(tank.getFluid())) {
            FluidStack drained = tank.drain(resource.amount, doDrain);
            if (doDrain && drained != null && drained.amount > 0) {
                this.updateTank(slot);
                this.func_70296_d();
            }
            return drained;
        }
        return null;
    }

    protected final FluidStack drainTank(int slot, int maxDrain, boolean doDrain) {
        FluidTank tank = this.getTank(slot);
        FluidStack drained = tank.drain(maxDrain, doDrain);
        if (doDrain && drained != null && drained.amount > 0) {
            this.updateTank(slot);
            this.func_70296_d();
        }
        return drained;
    }

    protected final int fillTank(int slot, FluidStack resource, boolean doFill) {
        FluidTank tank = this.getTank(slot);
        int filled = tank.fill(resource, doFill);
        if (doFill && filled > 0) {
            this.updateTank(slot);
            this.func_70296_d();
        }
        return filled;
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
        IItemHandler item_handler;
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            IFluidHandler fluid_handler = this.getFluidHandler(facing);
            if (fluid_handler != null) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.getFluidHandler(facing));
            }
        } else if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (item_handler = this.getItemHandler(facing)) != null) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.getItemHandler(facing));
        }
        return (T)super.getCapability(cap, facing);
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public int func_174890_g() {
        return 0;
    }

    protected IFluidHandler getFluidHandler(EnumFacing facing) {
        return null;
    }

    public int func_70297_j_() {
        return 64;
    }

    protected IItemHandler getItemHandler(EnumFacing facing) {
        return null;
    }

    public String func_70005_c_() {
        return null;
    }

    public RedstoneMode getRedstoneMode() {
        return this.mode;
    }

    public final ItemStack func_70301_a(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public abstract FluidTank getTank(int var1);

    public abstract int getTankCount();

    public final SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.getFluidHandler(facing) != null || super.hasCapability(cap, facing);
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getItemHandler(facing) != null || super.hasCapability(cap, facing);
        }
        return super.hasCapability(cap, facing);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.initialized = false;
        this.onChunkUnload();
    }

    public boolean func_191420_l() {
        for (ItemStack s : this.inventory) {
            if (s.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) != this ? false : player.func_174818_b(this.func_174877_v()) <= 64.0;
    }

    public final void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        if (this.field_145850_b.field_72995_K) {
            this.func_145839_a(pkt.func_148857_g());
        }
    }

    protected abstract void onInitialize();

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_145839_a(NBTTagCompound compound) {
        NBTTagCompound tag;
        int i;
        super.func_145839_a(compound);
        for (i = 0; i < this.getTankCount(); ++i) {
            tag = (NBTTagCompound)compound.func_74781_a("Tank_" + String.valueOf(i));
            if (tag == null) continue;
            FluidTank tank = this.getTank(i);
            tank.setFluid(null);
            tank.readFromNBT(tag);
        }
        for (i = 0; i < this.func_70302_i_(); ++i) {
            tag = (NBTTagCompound)compound.func_74781_a("Item_" + String.valueOf(i));
            if (tag == null) continue;
            ItemStack stack = ItemStack.field_190927_a;
            if (!tag.func_74767_n("empty")) {
                stack = new ItemStack(tag);
            }
            this.inventory.set(i, (Object)stack);
        }
        if (compound.func_74764_b("rsmode")) {
            this.mode = RedstoneMode.fromID(compound.func_74762_e("rsmode"));
        }
        if (compound.func_74764_b("bucket_timer")) {
            this.container_timer = compound.func_74762_e("container_timer");
        }
    }

    public ItemStack func_70304_b(int slot) {
        if (!this.func_70301_a(slot).func_190926_b()) {
            ItemStack is = this.func_70301_a(slot);
            this.setStackInSlot(slot, ItemStack.field_190927_a);
            this.updateInventoryItem(slot);
            this.func_70296_d();
            return is;
        }
        return ItemStack.field_190927_a;
    }

    protected void sendPacketToNearbyPlayers(NBTTagCompound data) {
        data.func_74768_a("dim", this.field_145850_b.field_73011_w.getDimension());
        Foundry.NETWORK.sendToAllAround((IMessage)new MessageTileEntitySync(data), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 192.0));
    }

    protected void sendPacketToPlayer(NBTTagCompound data, EntityPlayerMP player) {
        data.func_74768_a("dim", this.field_145850_b.field_73011_w.getDimension());
        Foundry.NETWORK.sendTo((IMessage)new MessageTileEntitySync(data), player);
    }

    protected void sendToServer(NBTTagCompound tag) {
        if (this.field_145850_b.field_72995_K) {
            super.func_189515_b(tag);
            tag.func_74768_a("dim", this.field_145850_b.field_73011_w.getDimension());
            Foundry.NETWORK.sendToServer((IMessage)new MessageTileEntitySync(tag));
        }
    }

    public void func_174885_b(int id, int value) {
    }

    public final void func_70299_a(int slot, ItemStack stack) {
        this.setStackInSlot(slot, stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.updateInventoryItem(slot);
        this.func_70296_d();
    }

    public void setRedstoneMode(RedstoneMode new_mode) {
        if (this.mode != new_mode) {
            this.mode = new_mode;
            if (this.field_145850_b.field_72995_K) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("rsmode", this.mode.id);
                this.sendToServer(tag);
            }
        }
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
    }

    public void func_73660_a() {
        if (!this.initialized && !this.func_145837_r()) {
            this.updateRedstone();
            this.onInitialize();
            this.initialized = true;
        }
        if (!this.field_145850_b.field_72995_K) {
            for (ContainerSlot cs : this.conatiner_slots) {
                cs.update();
            }
            if (this.container_timer > 0) {
                --this.container_timer;
            }
            this.updateServer();
        } else {
            this.updateClient();
        }
        this.last_redstone_signal = this.redstone_signal;
    }

    protected abstract void updateClient();

    @OverridingMethodsMustInvokeSuper
    protected void updateInventoryItem(int slot) {
    }

    public void updateRedstone() {
        this.redstone_signal = this.field_145850_b.func_175640_z(this.func_174877_v());
    }

    protected abstract void updateServer();

    @OverridingMethodsMustInvokeSuper
    protected void updateTank(int slot) {
    }

    protected final void writeInventoryItemToNBT(NBTTagCompound compound, int slot) {
        ItemStack is = this.func_70301_a(slot);
        NBTTagCompound tag = new NBTTagCompound();
        if (is != null) {
            tag.func_74757_a("empty", false);
            is.func_77955_b(tag);
        } else {
            tag.func_74757_a("empty", true);
        }
        compound.func_74782_a("Item_" + String.valueOf(slot), (NBTBase)tag);
    }

    protected final void writeTankToNBT(NBTTagCompound compound, int slot) {
        NBTTagCompound tag = new NBTTagCompound();
        this.getTank(slot).writeToNBT(tag);
        compound.func_74782_a("Tank_" + String.valueOf(slot), (NBTBase)tag);
    }

    protected void writeTileToNBT(NBTTagCompound compound) {
        super.func_189515_b(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        int i;
        super.func_189515_b(compound);
        for (i = 0; i < this.getTankCount(); ++i) {
            this.writeTankToNBT(compound, i);
        }
        for (i = 0; i < this.func_70302_i_(); ++i) {
            this.writeInventoryItemToNBT(compound, i);
        }
        compound.func_74768_a("rsmode", this.mode.id);
        compound.func_74768_a("container_timer", this.container_timer);
        return compound;
    }

    public void sendDataToClientSide(EntityPlayerMP player) {
        if (!this.field_145850_b.field_72995_K) {
            this.sendPacketToPlayer(this.func_189517_E_(), player);
        }
    }

    public void sendDataToClientSide() {
        if (!this.field_145850_b.field_72995_K) {
            this.sendPacketToNearbyPlayers(this.func_189517_E_());
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public static enum RedstoneMode {
        RSMODE_IGNORE(0),
        RSMODE_ON(1),
        RSMODE_OFF(2),
        RSMODE_PULSE(3);

        public final int id;

        public static RedstoneMode fromID(int num) {
            for (RedstoneMode m : RedstoneMode.values()) {
                if (m.id != num) continue;
                return m;
            }
            return RSMODE_IGNORE;
        }

        private RedstoneMode(int num) {
            this.id = num;
        }
    }

    public class ItemHandler
    extends ItemStackHandler {
        protected final int slots;
        protected final ImmutableSet<Integer> insert_slots;
        protected final ImmutableSet<Integer> extract_slots;

        public ItemHandler(int slots, Set<Integer> insert_slots, Set<Integer> extract_slots) {
            super(TileEntityFoundry.this.inventory);
            this.slots = slots;
            this.insert_slots = ImmutableSet.copyOf(insert_slots);
            this.extract_slots = ImmutableSet.copyOf(extract_slots);
        }

        protected boolean canExtract(int slot) {
            return true;
        }

        protected boolean canInsert(int slot, ItemStack stack) {
            return TileEntityFoundry.this.func_94041_b(slot, stack);
        }

        public final ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!this.extract_slots.contains((Object)slot) || !this.canExtract(slot)) {
                return ItemStack.field_190927_a;
            }
            return super.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return TileEntityFoundry.this.func_70297_j_();
        }

        public final int getSlots() {
            return this.slots;
        }

        public final ItemStack getStackInSlot(int slot) {
            return (ItemStack)TileEntityFoundry.this.inventory.get(slot);
        }

        public final ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!this.insert_slots.contains((Object)slot) || !this.canInsert(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        protected void onContentsChanged(int slot) {
            TileEntityFoundry.this.updateInventoryItem(slot);
            TileEntityFoundry.this.func_70296_d();
        }
    }

    protected class FluidHandler
    implements IFluidHandler {
        private final int fill_tank;
        private final int drain_tank;
        private final IFluidTankProperties[] props;

        public FluidHandler(int fill_tank, int drain_tank) {
            this.fill_tank = fill_tank;
            this.drain_tank = drain_tank;
            this.props = new IFluidTankProperties[TileEntityFoundry.this.getTankCount()];
            for (int i = 0; i < this.props.length; ++i) {
                this.props[i] = new FluidTankPropertiesWrapper(TileEntityFoundry.this.getTank(i));
            }
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (this.drain_tank < 0) {
                return null;
            }
            return TileEntityFoundry.this.drainTank(this.drain_tank, resource, doDrain);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (this.drain_tank < 0) {
                return null;
            }
            return TileEntityFoundry.this.drainTank(this.drain_tank, maxDrain, doDrain);
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (this.fill_tank < 0) {
                return 0;
            }
            return TileEntityFoundry.this.fillTank(this.fill_tank, resource, doFill);
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.props;
        }
    }

    public class ContainerSlot {
        final boolean fill;
        final int tank_slot;
        final int input_slot;
        final int output_slot;

        public ContainerSlot(int tank_slot, int input_slot, int output_slot, boolean fill) {
            this.tank_slot = tank_slot;
            this.input_slot = input_slot;
            this.output_slot = output_slot;
            this.fill = fill;
        }

        public void update() {
            if (TileEntityFoundry.this.container_timer > 0) {
                return;
            }
            ItemStack stackInput = TileEntityFoundry.this.func_70301_a(this.input_slot);
            ItemStack stackOutput = TileEntityFoundry.this.func_70301_a(this.output_slot);
            if (stackInput.func_190926_b() || !stackOutput.func_190926_b()) {
                return;
            }
            FluidTank tank = TileEntityFoundry.this.getTank(this.tank_slot);
            if (stackInput.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                FluidStack transfer;
                boolean isEmpty;
                IFluidHandlerItem handler = (IFluidHandlerItem)stackInput.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                FluidStack sample = handler.drain(Integer.MAX_VALUE, false);
                boolean bl = isEmpty = sample == null;
                boolean isFull = isEmpty ? false : handler.fill(sample, false) <= 0;
                boolean flag = false;
                if (this.fill && !isEmpty || !this.fill && isFull) {
                    transfer = FluidUtil.tryFluidTransfer((IFluidHandler)tank, (IFluidHandler)handler, (int)1000, (boolean)true);
                    if (handler.drain(Integer.MAX_VALUE, false) == null) {
                        TileEntityFoundry.this.inventory.set(this.output_slot, (Object)handler.getContainer());
                        TileEntityFoundry.this.inventory.set(this.input_slot, (Object)ItemStack.field_190927_a);
                        TileEntityFoundry.this.updateInventoryItem(this.input_slot);
                        TileEntityFoundry.this.updateInventoryItem(this.output_slot);
                        flag = true;
                    }
                } else {
                    transfer = FluidUtil.tryFluidTransfer((IFluidHandler)handler, (IFluidHandler)tank, (int)1000, (boolean)true);
                    if (handler.fill(sample, false) <= 0) {
                        TileEntityFoundry.this.inventory.set(this.output_slot, (Object)handler.getContainer());
                        TileEntityFoundry.this.inventory.set(this.input_slot, (Object)ItemStack.field_190927_a);
                        TileEntityFoundry.this.updateInventoryItem(this.input_slot);
                        TileEntityFoundry.this.updateInventoryItem(this.output_slot);
                        flag = true;
                    }
                }
                if (transfer != null) {
                    TileEntityFoundry.this.container_timer = transfer.amount / 25;
                    if (!flag) {
                        TileEntityFoundry.this.inventory.set(this.input_slot, (Object)handler.getContainer());
                        TileEntityFoundry.this.updateInventoryItem(this.input_slot);
                    }
                    TileEntityFoundry.this.updateTank(this.tank_slot);
                } else if (!flag) {
                    TileEntityFoundry.this.inventory.set(this.output_slot, TileEntityFoundry.this.inventory.get(this.input_slot));
                    TileEntityFoundry.this.inventory.set(this.input_slot, (Object)ItemStack.field_190927_a);
                    TileEntityFoundry.this.updateInventoryItem(this.input_slot);
                    TileEntityFoundry.this.updateInventoryItem(this.output_slot);
                }
            }
        }
    }
}

