/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity;

import exter.foundry.api.FoundryAPI;
import exter.foundry.api.heatable.IHeatProvider;
import exter.foundry.api.recipe.IFluidHeaterFuel;
import exter.foundry.recipes.manager.FluidHeaterFuelManager;
import exter.foundry.tileentity.TileEntityFoundry;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityFluidHeater
extends TileEntityFoundry {
    private final FluidTank tank;
    private final HeatProvider heatProvider = new HeatProvider();
    public static final int INVENTORY_CONTAINER_INPUT = 0;
    public static final int INVENTORY_CONTAINER_OUTPUT = 1;

    public TileEntityFluidHeater() {
        this.tank = new FluidTank(6000){

            public boolean canFillFluidType(FluidStack fluid) {
                return this.canFill() && FluidHeaterFuelManager.INSTANCE.getFuel(fluid.getFluid()) != null;
            }
        };
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(this, 0, 0, 1, true));
    }

    public int func_70302_i_() {
        return 2;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    @Override
    public FluidTank getTank(int slot) {
        if (slot != 0) {
            return null;
        }
        return this.tank;
    }

    @Override
    public int getTankCount() {
        return 1;
    }

    @Override
    protected void onInitialize() {
    }

    @Override
    protected void updateClient() {
    }

    @Override
    protected void updateServer() {
    }

    @Override
    public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
        if (cap == FoundryAPI.HEAT_PROVIDER_CAP && facing == EnumFacing.UP) {
            return (T)FoundryAPI.HEAT_PROVIDER_CAP.cast((Object)this.heatProvider);
        }
        return super.getCapability(cap, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        return cap == FoundryAPI.HEAT_PROVIDER_CAP && facing == EnumFacing.UP || super.hasCapability(cap, facing);
    }

    @Override
    protected IFluidHandler getFluidHandler(EnumFacing facing) {
        return this.tank;
    }

    private class HeatProvider
    implements IHeatProvider {
        private HeatProvider() {
        }

        @Override
        public int provideHeat(int max_heat, int heat) {
            FluidStack fluidStack = TileEntityFluidHeater.this.tank.drain(1, true);
            if (fluidStack == null) {
                return 0;
            }
            IFluidHeaterFuel fuel = FluidHeaterFuelManager.INSTANCE.getFuel(fluidStack.getFluid());
            if (fuel != null && fuel.getHeat() > 30000) {
                return fuel.getHeat();
            }
            return 0;
        }
    }
}

