/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity;

import com.google.common.collect.ImmutableSet;
import exter.foundry.api.FoundryUtils;
import exter.foundry.api.recipe.ICastingTableRecipe;
import exter.foundry.recipes.manager.CastingTableRecipeManager;
import exter.foundry.tileentity.TileEntityFoundry;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.FluidTankPropertiesWrapper;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;

public abstract class TileEntityCastingTableBase
extends TileEntityFoundry {
    private static final Set<Integer> IH_SLOTS_INPUT = ImmutableSet.of();
    private static final Set<Integer> IH_SLOTS_OUTPUT = ImmutableSet.of((Object)0);
    private final FluidTank tank = new FluidTank(this.getDefaultCapacity());
    private final IFluidHandler fluid_handler = new FluidHandler();
    private ICastingTableRecipe recipe;
    private int totalTick = 0;
    private int progress = 0;
    private final ItemHandlerTable item_handler = new ItemHandlerTable(this.func_70302_i_(), IH_SLOTS_INPUT, IH_SLOTS_OUTPUT);

    public abstract int getDefaultCapacity();

    @Override
    protected IFluidHandler getFluidHandler(EnumFacing facing) {
        return this.fluid_handler;
    }

    @Override
    protected IItemHandler getItemHandler(EnumFacing facing) {
        return this.item_handler;
    }

    public final int getProgress() {
        return this.progress;
    }

    public int getTotalTick() {
        return this.totalTick;
    }

    public final int func_70302_i_() {
        return 1;
    }

    public abstract ICastingTableRecipe.TableType getTableType();

    @Override
    public final FluidTank getTank(int slot) {
        return this.tank;
    }

    @Override
    public final int getTankCount() {
        return 1;
    }

    public final boolean func_94041_b(int slot, ItemStack itemstack) {
        return false;
    }

    @Override
    protected final void onInitialize() {
    }

    @Override
    public final void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("Tank_0")) {
            this.setRecipe(this.tank.getFluid());
        }
        if (compound.func_74764_b("progress")) {
            this.progress = compound.func_74762_e("progress");
        }
        if (compound.func_74764_b("total")) {
            this.totalTick = compound.func_74762_e("total");
        }
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && compound.func_74764_b("tank_capacity")) {
            this.tank.setCapacity(compound.func_74762_e("tank_capacity"));
        }
    }

    @Override
    @Deprecated
    public final ItemStack func_70304_b(int slot) {
        if (this.progress > 0) {
            return ItemStack.field_190927_a;
        }
        return super.func_70304_b(slot);
    }

    private void setRecipe(FluidStack fluid) {
        if (fluid == null || fluid.amount == 0) {
            this.recipe = null;
            this.tank.setCapacity(this.getDefaultCapacity());
            this.progress = 0;
            this.totalTick = 0;
            return;
        }
        this.recipe = CastingTableRecipeManager.INSTANCE.findRecipe(fluid, this.getTableType());
        if (this.recipe != null) {
            if (this.recipe.getOutput().func_190926_b()) {
                this.recipe = null;
                this.tank.setCapacity(this.getDefaultCapacity());
                this.sendDataToClientSide();
                return;
            }
            this.tank.setCapacity(this.recipe.getInput().amount);
            this.sendDataToClientSide();
        }
    }

    @Override
    protected void updateClient() {
    }

    @Override
    protected final void updateServer() {
        int last_progress = this.progress;
        if (this.progress > 0) {
            if (--this.progress == 0) {
                this.func_70299_a(0, this.recipe.getOutput());
                this.tank.setFluid(null);
                this.updateTank(0);
                this.setRecipe(null);
            }
        } else if (this.tank.getFluid() != null && ((ItemStack)this.inventory.get(0)).func_190926_b() && this.recipe != null && this.tank.getFluid().amount == this.recipe.getInput().amount) {
            this.totalTick = this.progress = FoundryUtils.getCastTime(this.tank.getFluid());
        }
        if (last_progress != this.progress && last_progress % 10 == 0) {
            this.sendDataToClientSide();
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("progress", this.progress);
        compound.func_74768_a("total", this.totalTick);
        return compound;
    }

    @Override
    protected void updateInventoryItem(int slot) {
        super.updateInventoryItem(slot);
        this.sendDataToClientSide();
    }

    @Override
    protected void updateTank(int slot) {
        super.updateTank(slot);
        this.sendDataToClientSide();
    }

    private class ItemHandlerTable
    extends TileEntityFoundry.ItemHandler {
        public ItemHandlerTable(int slots, Set<Integer> insert_slots, Set<Integer> extract_slots) {
            super(TileEntityCastingTableBase.this, slots, insert_slots, extract_slots);
        }

        @Override
        protected boolean canInsert(int slot, ItemStack stack) {
            return false;
        }
    }

    protected class FluidHandler
    implements IFluidHandler {
        private final IFluidTankProperties[] props;

        public FluidHandler() {
            this.props = new IFluidTankProperties[TileEntityCastingTableBase.this.getTankCount()];
            for (int i = 0; i < this.props.length; ++i) {
                this.props[i] = new FluidTankPropertiesWrapper(TileEntityCastingTableBase.this.getTank(i));
            }
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (TileEntityCastingTableBase.this.progress > 0) {
                return null;
            }
            FluidStack result = TileEntityCastingTableBase.this.drainTank(0, resource, doDrain);
            if (doDrain) {
                TileEntityCastingTableBase.this.setRecipe(TileEntityCastingTableBase.this.tank.getFluid());
                TileEntityCastingTableBase.this.sendDataToClientSide();
            }
            return result;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (TileEntityCastingTableBase.this.progress > 0) {
                return null;
            }
            FluidStack result = TileEntityCastingTableBase.this.drainTank(0, maxDrain, doDrain);
            if (doDrain) {
                TileEntityCastingTableBase.this.setRecipe(TileEntityCastingTableBase.this.tank.getFluid());
                TileEntityCastingTableBase.this.sendDataToClientSide();
            }
            return result;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (!((ItemStack)TileEntityCastingTableBase.this.inventory.get(0)).func_190926_b()) {
                return 0;
            }
            ICastingTableRecipe testRecipe = CastingTableRecipeManager.INSTANCE.findRecipe(resource, TileEntityCastingTableBase.this.getTableType());
            if (testRecipe == null) {
                return 0;
            }
            if (doFill && (TileEntityCastingTableBase.this.tank.getFluid() == null || ((TileEntityCastingTableBase)TileEntityCastingTableBase.this).tank.getFluid().amount == 0)) {
                TileEntityCastingTableBase.this.setRecipe(resource);
                TileEntityCastingTableBase.this.sendDataToClientSide();
            }
            return TileEntityCastingTableBase.this.fillTank(0, resource, doFill);
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.props;
        }
    }
}

