/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import exter.foundry.api.FoundryAPI;
import exter.foundry.api.heatable.IHeatProvider;
import exter.foundry.api.recipe.IBurnerHeaterFuel;
import exter.foundry.block.BlockBurnerHeater;
import exter.foundry.config.FoundryConfig;
import exter.foundry.recipes.manager.BurnerHeaterFuelManager;
import exter.foundry.tileentity.TileEntityFoundry;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.IItemHandler;
import vazkii.botania.api.item.IExoflameHeatable;

@Optional.Interface(iface="vazkii.botania.api.item.IExoflameHeatable", modid="Botania")
public class TileEntityBurnerHeater
extends TileEntityFoundry
implements IExoflameHeatable {
    private boolean updated = false;
    private static final Set<Integer> IH_SLOTS_FUEL = ImmutableSet.of((Object)0, (Object)1, (Object)2, (Object)3);
    private List<Fuel> fuels = ImmutableList.of((Object)new Fuel(), (Object)new Fuel(), (Object)new Fuel(), (Object)new Fuel());
    private final HeatProvider heat_provider = new HeatProvider();
    private final TileEntityFoundry.ItemHandler item_handler = new TileEntityFoundry.ItemHandler(this, this.func_70302_i_(), IH_SLOTS_FUEL, IH_SLOTS_FUEL);

    public double getSumBoost() {
        int count = (int)this.fuels.stream().filter(Fuel::isBurning).count();
        if (count == 0) {
            return 0.0;
        }
        if (count == this.fuels.size()) {
            return 1.0;
        }
        double sum = 0.0;
        for (Fuel fuel : this.fuels) {
            if (!fuel.isBurning()) continue;
            sum += fuel.getBoost();
        }
        return 0.4 + (double)count * 0.15 + sum * (double)(this.fuels.size() - count) * 0.15 / (double)count;
    }

    public int getHeat() {
        int sum = 0;
        int count = 0;
        for (Fuel fuel : this.fuels) {
            if (!fuel.isBurning()) continue;
            ++count;
            sum += fuel.heat;
        }
        return count == 0 ? 30000 : sum / count;
    }

    @Optional.Method(modid="Botania")
    public void boostBurnTime() {
        if (!this.field_145850_b.field_72995_K) {
            for (Fuel fuel : this.fuels) {
                if (fuel.isBurning()) continue;
                fuel.totalBurnTime = 200;
                fuel.burnTime = 200;
                fuel.heat = FoundryConfig.default_burner_exoflame_heat;
            }
            ((BlockBurnerHeater)this.func_145838_q()).setMachineState(this.field_145850_b, this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.isBurning());
            this.func_70296_d();
        }
    }

    @Optional.Method(modid="Botania")
    public void boostCookTime() {
    }

    @Optional.Method(modid="Botania")
    public boolean canSmelt() {
        return !this.fuels.stream().allMatch(Fuel::isBurning);
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
    }

    @Optional.Method(modid="Botania")
    public int getBurnTime() {
        int time = 0;
        for (Fuel fuel : this.fuels) {
            if (time != 0 && time <= fuel.burnTime) continue;
            time = fuel.burnTime;
        }
        return time;
    }

    @Override
    public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
        if (cap == FoundryAPI.HEAT_PROVIDER_CAP && facing == EnumFacing.UP) {
            return (T)FoundryAPI.HEAT_PROVIDER_CAP.cast((Object)this.heat_provider);
        }
        return super.getCapability(cap, facing);
    }

    @Override
    protected IItemHandler getItemHandler(EnumFacing side) {
        return this.item_handler;
    }

    public int func_70302_i_() {
        return 4;
    }

    @Override
    public FluidTank getTank(int slot) {
        return null;
    }

    @Override
    public int getTankCount() {
        return 0;
    }

    @Override
    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        return super.hasCapability(cap, facing) || cap == FoundryAPI.HEAT_PROVIDER_CAP && facing == EnumFacing.UP;
    }

    public boolean isBurning() {
        return this.fuels.stream().anyMatch(Fuel::isBurning);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return TileEntityBurnerHeater.isValidFuel(stack);
    }

    public static boolean isValidFuel(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151129_at) {
            return false;
        }
        return BurnerHeaterFuelManager.INSTANCE.getFuel(stack) != null || FoundryConfig.enable_default_burner_fuel && TileEntityFurnace.func_145954_b((ItemStack)stack);
    }

    @Override
    protected void onInitialize() {
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Override
    protected void updateClient() {
    }

    @Override
    protected void updateServer() {
        List burnings = this.fuels.stream().filter(Fuel::isBurning).collect(Collectors.toList());
        if (burnings.size() > 0) {
            int times = Math.max(1, burnings.size() - 1);
            for (int i = 0; i < times; ++i) {
                int index = this.func_145831_w().field_73012_v.nextInt(burnings.size());
                Fuel fuel = (Fuel)burnings.get(index);
                if (--fuel.burnTime != 0) continue;
                fuel.heat = 30000;
                fuel.totalBurnTime = 0;
                burnings.remove(index);
                this.updated = true;
            }
        }
        if (this.updated) {
            ((BlockBurnerHeater)this.func_145838_q()).setMachineState(this.field_145850_b, this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.isBurning());
            this.updated = false;
        }
    }

    private void tryBurnNextFuel() {
        for (int i = 0; i < this.fuels.size(); ++i) {
            if (this.fuels.get(i).isBurning() || !this.tryBurnItemInSlot(i)) continue;
            this.updated = true;
        }
    }

    private boolean tryBurnItemInSlot(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() == Items.field_151129_at) {
                return false;
            }
            Fuel fuel = this.fuels.get(slot);
            IBurnerHeaterFuel ifuel = BurnerHeaterFuelManager.INSTANCE.getFuel(stack);
            if (ifuel != null) {
                fuel.totalBurnTime = fuel.burnTime = ifuel.getBurnTime();
                fuel.heat = ifuel.getHeat();
            } else if (FoundryConfig.enable_default_burner_fuel) {
                int time = TileEntityFurnace.func_145952_a((ItemStack)stack);
                if (time <= 0) {
                    return false;
                }
                fuel.totalBurnTime = fuel.burnTime = time;
                fuel.heat = FoundryConfig.default_burner_fuel_heat;
            }
            ItemStack stackCopy = stack.func_77946_l();
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                this.func_70299_a(slot, stackCopy.func_77973_b().getContainerItem(stackCopy));
            }
            this.updateInventoryItem(slot);
            return true;
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        for (int i = 0; i < this.fuels.size(); ++i) {
            this.fuels.get(i).deserializeNBT(tag.func_74775_l("Fuel_" + i));
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ((BlockBurnerHeater)this.func_145838_q()).setMachineState(this.field_145850_b, this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.isBurning());
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        for (int i = 0; i < this.fuels.size(); ++i) {
            tag.func_74782_a("Fuel_" + i, (NBTBase)this.fuels.get(i).serializeNBT());
        }
        return tag;
    }

    public static class Fuel
    implements INBTSerializable<NBTTagCompound> {
        public int burnTime;
        public int totalBurnTime;
        public int heat;

        public boolean isBurning() {
            return this.totalBurnTime > 0;
        }

        public double getBoost() {
            if (this.totalBurnTime == 0) {
                return 0.0;
            }
            return (double)this.burnTime / (double)this.totalBurnTime;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("time", this.burnTime);
            tag.func_74768_a("total", this.totalBurnTime);
            tag.func_74768_a("heat", this.heat);
            return tag;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            if (nbt != null) {
                this.burnTime = nbt.func_74764_b("time") ? nbt.func_74762_e("time") : this.burnTime;
                this.totalBurnTime = nbt.func_74764_b("total") ? nbt.func_74762_e("total") : this.totalBurnTime;
                this.heat = nbt.func_74764_b("heat") ? nbt.func_74762_e("heat") : FoundryConfig.default_burner_fuel_heat;
            }
        }
    }

    private class HeatProvider
    implements IHeatProvider {
        private HeatProvider() {
        }

        @Override
        public int provideHeat(int max_heat, int heat) {
            if (TileEntityBurnerHeater.this.fuels.stream().filter(Fuel::isBurning).count() < 4L) {
                TileEntityBurnerHeater.this.tryBurnNextFuel();
            }
            if (TileEntityBurnerHeater.this.isBurning()) {
                heat = (int)(TileEntityBurnerHeater.this.getSumBoost() * (double)TileEntityBurnerHeater.this.getHeat());
                return heat;
            }
            return 0;
        }
    }
}

