/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.tileentity;

import exter.foundry.api.recipe.IAlloyingCrucibleRecipe;
import exter.foundry.recipes.manager.AlloyingCrucibleRecipeManager;
import exter.foundry.tileentity.TileEntityFoundry;
import exter.foundry.util.MiscUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.FluidTankPropertiesWrapper;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntityAlloyingCrucible
extends TileEntityFoundry {
    public static final int INVENTORY_CONTAINER_INPUT_A_DRAIN = 0;
    public static final int INVENTORY_CONTAINER_INPUT_A_FILL = 1;
    public static final int INVENTORY_CONTAINER_INPUT_B_DRAIN = 2;
    public static final int INVENTORY_CONTAINER_INPUT_B_FILL = 3;
    public static final int INVENTORY_CONTAINER_OUTPUT_DRAIN = 4;
    public static final int INVENTORY_CONTAINER_OUTPUT_FILL = 5;
    public static final int TANK_INPUT_A = 0;
    public static final int TANK_INPUT_B = 1;
    public static final int TANK_OUTPUT = 2;
    public int progress;
    private final FluidTank[] tanks = new FluidTank[3];
    private final IFluidHandler fluid_handler;

    public TileEntityAlloyingCrucible() {
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i] = new FluidTank(3000);
        }
        this.fluid_handler = new FluidHandler();
        this.progress = 0;
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(this, 0, 0, 1, false));
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(this, 1, 2, 3, false));
        this.addContainerSlot(new TileEntityFoundry.ContainerSlot(this, 2, 4, 5, false));
    }

    private boolean canOutput(IAlloyingCrucibleRecipe recipe) {
        FluidStack output = recipe.getOutput();
        return this.tanks[2].fill(output, false) == output.amount;
    }

    private void doMix(IAlloyingCrucibleRecipe recipe, boolean reversed) {
        if (reversed) {
            this.drainTank(1, recipe.getInputA(), true);
            this.drainTank(0, recipe.getInputB(), true);
        } else {
            this.drainTank(0, recipe.getInputA(), true);
            this.drainTank(1, recipe.getInputB(), true);
        }
        this.fillTank(2, recipe.getOutput(), true);
    }

    @Override
    protected IFluidHandler getFluidHandler(EnumFacing facing) {
        return this.fluid_handler;
    }

    public int func_70302_i_() {
        return 6;
    }

    @Override
    public FluidTank getTank(int slot) {
        return this.tanks[slot];
    }

    @Override
    public int getTankCount() {
        return 3;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    @Override
    protected void onInitialize() {
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("Progress")) {
            this.progress = tag.func_74762_e("Progress");
        }
    }

    @Override
    protected void updateClient() {
    }

    @Override
    protected void updateServer() {
        int last_progress = this.progress;
        boolean reversed = false;
        IAlloyingCrucibleRecipe recipe = null;
        if (this.tanks[0].getFluid() != null && this.tanks[1].getFluid() != null && (recipe = AlloyingCrucibleRecipeManager.INSTANCE.findRecipe(this.tanks[0].getFluid(), this.tanks[1].getFluid())) == null && (recipe = AlloyingCrucibleRecipeManager.INSTANCE.findRecipe(this.tanks[1].getFluid(), this.tanks[0].getFluid())) != null) {
            reversed = true;
        }
        if (recipe != null && this.canOutput(recipe)) {
            if (++this.progress >= MiscUtil.divCeil(recipe.getOutput().amount, 2)) {
                this.progress = 0;
                this.doMix(recipe, reversed);
            }
        } else {
            this.progress = 0;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Progress", this.progress);
        return compound;
    }

    protected class FluidHandler
    implements IFluidHandler {
        private final IFluidTankProperties[] props;

        public FluidHandler() {
            this.props = new IFluidTankProperties[TileEntityAlloyingCrucible.this.getTankCount()];
            for (int i = 0; i < this.props.length; ++i) {
                this.props[i] = new FluidTankPropertiesWrapper(TileEntityAlloyingCrucible.this.getTank(i));
            }
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return TileEntityAlloyingCrucible.this.drainTank(2, resource, doDrain);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            return TileEntityAlloyingCrucible.this.drainTank(2, maxDrain, doDrain);
        }

        public int fill(FluidStack resource, boolean doFill) {
            int empty = -1;
            int partial = -1;
            for (int i = 0; i < 2; ++i) {
                FluidTank ft = TileEntityAlloyingCrucible.this.tanks[i];
                if (ft.getFluidAmount() > 0) {
                    if (!ft.getFluid().isFluidEqual(resource)) continue;
                    if (ft.getFluidAmount() < ft.getCapacity()) {
                        partial = i;
                        continue;
                    }
                    return 0;
                }
                empty = i;
            }
            if (partial != -1) {
                return TileEntityAlloyingCrucible.this.fillTank(partial, resource, doFill);
            }
            if (empty != -1) {
                return TileEntityAlloyingCrucible.this.fillTank(empty, resource, doFill);
            }
            return 0;
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.props;
        }
    }
}

