/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.recipes.manager;

import exter.foundry.Foundry;
import exter.foundry.api.recipe.IMeltingRecipe;
import exter.foundry.api.recipe.manager.IMeltingRecipeManager;
import exter.foundry.api.recipe.matcher.IItemMatcher;
import exter.foundry.recipes.MeltingRecipe;
import exter.foundry.util.MiscUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;

public class MeltingRecipeManager
implements IMeltingRecipeManager {
    public static final MeltingRecipeManager INSTANCE = new MeltingRecipeManager();
    private final NonNullList<IMeltingRecipe> recipes = NonNullList.func_191196_a();
    private final Map<IMeltingRecipe, String> desc = new HashMap<IMeltingRecipe, String>();

    private MeltingRecipeManager() {
    }

    @Override
    public void addRecipe(IItemMatcher solid, FluidStack fluid_stack) {
        this.addRecipe(solid, fluid_stack, fluid_stack.getFluid().getTemperature());
    }

    @Override
    public void addRecipe(IItemMatcher solid, FluidStack fluid_stack, int melting_point) {
        this.addRecipe(solid, fluid_stack, melting_point, 100);
    }

    @Override
    public void addRecipe(IItemMatcher solid, FluidStack fluid_stack, int melting_point, int melting_speed) {
        if (!MiscUtil.isInvalid(solid)) {
            this.addRecipe(new MeltingRecipe(solid, fluid_stack, melting_point, melting_speed));
        }
    }

    public void addRecipe(IMeltingRecipe recipe) {
        if (this.desc.values().stream().anyMatch(k -> k.equals(recipe.toString()))) {
            Foundry.LOGGER.warn("Detected duplicated recipe: " + recipe.toString());
            return;
        }
        this.recipes.add((Object)recipe);
        this.desc.put(recipe, recipe.toString());
    }

    @Override
    public IMeltingRecipe findRecipe(ItemStack item) {
        if (item.func_190926_b()) {
            return null;
        }
        for (IMeltingRecipe r : this.recipes) {
            if (!r.matchesRecipe(item)) continue;
            return r;
        }
        return null;
    }

    @Override
    public List<IMeltingRecipe> getRecipes() {
        return this.recipes;
    }

    @Override
    public void removeRecipe(IMeltingRecipe recipe) {
        this.recipes.remove((Object)recipe);
    }
}

