/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.recipes.manager;

import exter.foundry.api.recipe.ICastingTableRecipe;
import exter.foundry.api.recipe.manager.ICastingTableRecipeManager;
import exter.foundry.api.recipe.matcher.IItemMatcher;
import exter.foundry.recipes.CastingTableRecipe;
import exter.foundry.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fluids.FluidStack;

public class CastingTableRecipeManager
implements ICastingTableRecipeManager {
    public static final CastingTableRecipeManager INSTANCE = new CastingTableRecipeManager();
    private final Map<ICastingTableRecipe.TableType, Map<String, ICastingTableRecipe>> recipes = new EnumMap<ICastingTableRecipe.TableType, Map<String, ICastingTableRecipe>>(ICastingTableRecipe.TableType.class);

    private CastingTableRecipeManager() {
        for (ICastingTableRecipe.TableType type : ICastingTableRecipe.TableType.values()) {
            this.recipes.put(type, new HashMap());
        }
    }

    public void addRecipe(ICastingTableRecipe.TableType tableType, String name, ICastingTableRecipe recipe) {
        this.recipes.get((Object)tableType).put(name, recipe);
    }

    @Override
    public void addRecipe(IItemMatcher result, FluidStack fluid, ICastingTableRecipe.TableType type) {
        if (MiscUtil.isInvalid(result)) {
            return;
        }
        CastingTableRecipe recipe = new CastingTableRecipe(result, fluid, type);
        this.recipes.get((Object)recipe.getTableType()).put(recipe.getInput().getFluid().getName(), recipe);
    }

    @Override
    public ICastingTableRecipe findRecipe(FluidStack fluid, ICastingTableRecipe.TableType type) {
        if (type == null || fluid == null || fluid.amount == 0) {
            return null;
        }
        ICastingTableRecipe recipe = this.recipes.get((Object)type).get(fluid.getFluid().getName());
        return recipe;
    }

    @Override
    public List<ICastingTableRecipe> getRecipes() {
        ArrayList<ICastingTableRecipe> result = new ArrayList<ICastingTableRecipe>();
        for (ICastingTableRecipe.TableType type : ICastingTableRecipe.TableType.values()) {
            result.addAll(this.recipes.get((Object)type).values());
        }
        return result;
    }

    public Map<ICastingTableRecipe.TableType, Map<String, ICastingTableRecipe>> getRecipesMap() {
        return this.recipes;
    }

    public Collection<ICastingTableRecipe> getRecipes(ICastingTableRecipe.TableType type) {
        return this.recipes.get((Object)type).values();
    }

    @Override
    public void removeRecipe(ICastingTableRecipe recipe) {
        this.recipes.get((Object)recipe.getTableType()).remove(recipe.getInput().getFluid().getName());
    }

    public void removeRecipe(ICastingTableRecipe.TableType tableType, String name) {
        this.recipes.get((Object)tableType).remove(name);
    }
}

