/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.recipes.manager;

import exter.foundry.api.recipe.ICastingRecipe;
import exter.foundry.api.recipe.manager.ICastingRecipeManager;
import exter.foundry.api.recipe.matcher.IItemMatcher;
import exter.foundry.item.ItemMold;
import exter.foundry.recipes.CastingRecipe;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;

public class CastingRecipeManager
implements ICastingRecipeManager {
    public static final CastingRecipeManager INSTANCE = new CastingRecipeManager();
    private final NonNullList<ICastingRecipe> recipes = NonNullList.func_191196_a();

    private CastingRecipeManager() {
    }

    public void addRecipe(ICastingRecipe recipe) {
        this.recipes.add((Object)recipe);
    }

    @Override
    public void addRecipe(IItemMatcher result, FluidStack in_fluid, IItemMatcher in_mold, boolean comsume_mold, IItemMatcher in_extra, int tick) {
        CastingRecipe recipe = new CastingRecipe(result, in_fluid, in_mold, comsume_mold, in_extra, tick);
        if (recipe.requiresExtra()) {
            this.recipes.add(0, (Object)recipe);
        } else {
            this.recipes.add((Object)recipe);
        }
    }

    @Override
    public void addRecipe(IItemMatcher result, FluidStack in_fluid, ItemMold.SubItem in_mold, boolean comsume_mold, IItemMatcher in_extra, int cast_speed) {
        CastingRecipe recipe = new CastingRecipe(result, in_fluid, in_mold.getMatcher(), comsume_mold, in_extra, cast_speed);
        if (recipe.requiresExtra()) {
            this.recipes.add(0, (Object)recipe);
        } else {
            this.recipes.add((Object)recipe);
        }
    }

    public void addRecipe(int i, ICastingRecipe recipe) {
        this.recipes.add(i, (Object)recipe);
    }

    @Override
    public ICastingRecipe findRecipe(FluidStack fluid, ItemStack mold, ItemStack extra) {
        if (mold.func_190926_b() || fluid == null || fluid.amount == 0) {
            return null;
        }
        for (ICastingRecipe cr : this.recipes) {
            if (!cr.matchesRecipe(mold, fluid, extra)) continue;
            return cr;
        }
        return null;
    }

    @Override
    public List<ICastingRecipe> getRecipes() {
        return this.recipes;
    }

    @Override
    public boolean isItemMold(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (ICastingRecipe recipe : this.recipes) {
            if (!recipe.getMold().func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeRecipe(ICastingRecipe recipe) {
        this.recipes.remove((Object)recipe);
    }
}

