/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.recipes;

import exter.foundry.api.recipe.IMoldRecipe;
import java.util.Arrays;
import net.minecraft.item.ItemStack;

public class MoldRecipe
implements IMoldRecipe {
    public final int width;
    public final int height;
    public final int[] recipe;
    private final int[][] match_recipes;
    public final ItemStack output;

    public MoldRecipe(ItemStack output, int width, int height, int[] recipe) {
        if (output.func_190926_b()) {
            throw new IllegalArgumentException("Mold recipe output cannot be empty");
        }
        if (width < 1 || width > 6) {
            throw new IllegalArgumentException("Mold recipe width must be between 1 and 6.");
        }
        if (height < 1 || height > 6) {
            throw new IllegalArgumentException("Mold recipe height must be between 1 and 6.");
        }
        if (recipe == null || recipe.length < width * height) {
            throw new IllegalArgumentException("Mold recipe array cannot be null and the length must be at least width*height.");
        }
        for (int v : recipe) {
            if (v >= 0 && v <= 4) continue;
            throw new IllegalArgumentException("Mold recipe grid values must be between 0 and 4, inclusive.");
        }
        this.output = output.func_77946_l();
        this.width = width;
        this.height = height;
        this.recipe = (int[])recipe.clone();
        int match_x = 6 - width + 1;
        int match_y = 6 - height + 1;
        this.match_recipes = new int[match_x * match_y][36];
        for (int j = 0; j < match_y; ++j) {
            for (int i = 0; i < match_x; ++i) {
                int[] match_grid = this.match_recipes[j * match_x + i];
                Arrays.fill(match_grid, 0);
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        match_grid[(y + j) * 6 + x + i] = recipe[y * width + x];
                    }
                }
            }
        }
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    @Override
    public int[] getRecipeGrid() {
        return (int[])this.recipe.clone();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public boolean matchesRecipe(int[] grid) {
        for (int i = 0; i < this.match_recipes.length; ++i) {
            boolean matches = true;
            for (int j = 0; j < 36; ++j) {
                if (grid[j] == this.match_recipes[i][j]) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return true;
        }
        return false;
    }
}

