/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.recipes;

import exter.foundry.api.recipe.IMeltingRecipe;
import exter.foundry.api.recipe.matcher.IItemMatcher;
import exter.foundry.integration.crafttweaker.CrTHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class MeltingRecipe
implements IMeltingRecipe {
    private final FluidStack fluid;
    private final IItemMatcher solid;
    private final int melting_point;
    private final int melting_speed;

    public MeltingRecipe(IItemMatcher item, FluidStack fluid_stack, int melt, int speed) {
        if (fluid_stack == null) {
            throw new IllegalArgumentException("Melting recipe fluid cannot be null.");
        }
        if (melt < 301) {
            melt = 301;
        }
        if (speed < 1) {
            speed = 1;
        }
        this.solid = item;
        this.fluid = fluid_stack.copy();
        this.melting_point = melt;
        this.melting_speed = speed;
    }

    @Override
    public IItemMatcher getInput() {
        return this.solid;
    }

    @Override
    public int getMeltingPoint() {
        return this.melting_point;
    }

    @Override
    public int getMeltingSpeed() {
        return this.melting_speed;
    }

    @Override
    public FluidStack getOutput() {
        return this.fluid.copy();
    }

    @Override
    public boolean matchesRecipe(ItemStack item) {
        return this.solid.apply(item);
    }

    public String toString() {
        return String.format("Melting recipe: %s -> %s", CrTHelper.getItemDescription(this.solid), CrTHelper.getFluidDescription(this.fluid));
    }
}

