/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.recipes;

import exter.foundry.api.recipe.IInfuserRecipe;
import exter.foundry.api.recipe.matcher.IItemMatcher;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class InfuserRecipe
implements IInfuserRecipe {
    public final FluidStack fluid;
    public final IItemMatcher item;
    public final int extract_energy;
    public final FluidStack output;

    public InfuserRecipe(FluidStack result, FluidStack in_fluid, IItemMatcher in_item, int energy) {
        if (energy < 1) {
            throw new IllegalArgumentException("Infuser substance recipe energy nust be > 0.");
        }
        if (in_fluid == null) {
            throw new IllegalArgumentException("Infuser recipe input fluid cannot be null!");
        }
        if (result == null) {
            throw new IllegalArgumentException("Infuser recipe output cannot be null!");
        }
        if (in_item == null) {
            throw new IllegalArgumentException("Infuser Recipe input item cannot be null!");
        }
        this.item = in_item;
        this.fluid = in_fluid.copy();
        this.extract_energy = energy;
        this.output = result.copy();
    }

    @Override
    public int getEnergyNeeded() {
        return this.extract_energy;
    }

    @Override
    public IItemMatcher getInput() {
        return this.item;
    }

    @Override
    public FluidStack getInputFluid() {
        return this.fluid.copy();
    }

    @Override
    public FluidStack getOutput() {
        return this.output.copy();
    }

    @Override
    public boolean matchesRecipe(FluidStack in_fluid, ItemStack item_stack) {
        if (in_fluid == null || item_stack.func_190926_b()) {
            return false;
        }
        return this.item.apply(item_stack) && in_fluid.containsFluid(this.fluid);
    }
}

