/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.recipes;

import com.google.common.base.Preconditions;
import exter.foundry.api.recipe.ICastingRecipe;
import exter.foundry.api.recipe.matcher.IItemMatcher;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CastingRecipe
implements ICastingRecipe {
    private final FluidStack fluid;
    private final IItemMatcher mold;
    private final IItemMatcher extra;
    private final IItemMatcher output;
    private final int speed;
    private final boolean consume_mold;

    public CastingRecipe(IItemMatcher result, FluidStack in_fluid, IItemMatcher in_mold, boolean in_comsume_mold, @Nullable IItemMatcher in_extra, int cast_speed) {
        Preconditions.checkArgument((in_fluid != null ? 1 : 0) != 0);
        Preconditions.checkArgument((in_mold != null ? 1 : 0) != 0);
        Preconditions.checkArgument((cast_speed > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((result != null ? 1 : 0) != 0);
        this.output = result;
        this.fluid = in_fluid.copy();
        this.mold = in_mold;
        this.extra = in_extra;
        this.speed = cast_speed;
        this.consume_mold = in_comsume_mold;
    }

    @Override
    public boolean containsExtra(ItemStack stack) {
        return this.extra.apply(stack);
    }

    @Override
    public int getCastingTime() {
        return this.speed;
    }

    @Override
    public FluidStack getInput() {
        return this.fluid.copy();
    }

    @Override
    public IItemMatcher getInputExtra() {
        return this.extra;
    }

    @Override
    public ItemStack getMold() {
        return this.mold.getItem();
    }

    @Override
    public ItemStack getOutput() {
        return this.output.getItem();
    }

    @Override
    public IItemMatcher getOutputMatcher() {
        return this.output;
    }

    @Override
    public boolean matchesRecipe(ItemStack mold_stack, FluidStack fluid_stack, ItemStack in_extra) {
        return fluid_stack != null && fluid_stack.containsFluid(this.fluid) && this.mold.test(mold_stack) && (!this.requiresExtra() || this.extra.apply(in_extra));
    }

    @Override
    public boolean requiresExtra() {
        return this.extra != null;
    }

    @Override
    public boolean consumesMold() {
        return this.consume_mold;
    }
}

