/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.recipes;

import com.google.common.collect.ImmutableList;
import exter.foundry.api.recipe.IAlloyMixerRecipe;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.fluids.FluidStack;

public class AlloyMixerRecipe
implements IAlloyMixerRecipe {
    public List<FluidStack> inputs;
    public FluidStack output;

    public AlloyMixerRecipe(FluidStack out, FluidStack[] in) {
        this.output = out.copy();
        if (in == null || in.length == 0) {
            throw new IllegalArgumentException("Alloy mixer recipe inputs cannot be null");
        }
        if (in.length > 4) {
            throw new IllegalArgumentException("Alloy mixer recipe cannot have more the 4 inputs");
        }
        this.inputs = ImmutableList.copyOf(AlloyMixerRecipe.sortedFluids(Arrays.asList(in)));
        if (this.inputs.contains(null)) {
            throw new IllegalArgumentException("Alloy mixer recipe input cannot be null");
        }
    }

    @Override
    public List<FluidStack> getInputs() {
        return this.inputs;
    }

    @Override
    public FluidStack getOutput() {
        return this.output.copy();
    }

    @Override
    public boolean matchesRecipe(List<FluidStack> ins) {
        if (this.inputs.size() != ins.size()) {
            return false;
        }
        ins = AlloyMixerRecipe.sortedFluids(ins);
        for (int i = 0; i < this.inputs.size(); ++i) {
            FluidStack in;
            FluidStack input = this.inputs.get(i);
            if (input.isFluidEqual(in = ins.get(i)) && in.amount >= input.amount) continue;
            return false;
        }
        return true;
    }

    public static List<FluidStack> sortedFluids(List<FluidStack> fluidStacks) {
        return fluidStacks.stream().sorted(new Comp()).collect(Collectors.toList());
    }

    public static void mergeFluids(List<FluidStack> fluidStacks) {
        int i = 0;
        while (i + 1 < fluidStacks.size()) {
            FluidStack fs = fluidStacks.get(i);
            for (int j = i + 1; j < fluidStacks.size(); ++j) {
                if (!fs.isFluidEqual(fluidStacks.get(j))) continue;
                fluidStacks.get((int)j).amount += fs.amount;
                fluidStacks.set(i, null);
            }
            ++i;
        }
    }

    public static class Comp
    implements Comparator<FluidStack> {
        @Override
        public int compare(FluidStack o1, FluidStack o2) {
            return Integer.compare(o1.hashCode(), o2.hashCode());
        }
    }
}

