/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.proxy;

import exter.foundry.client.renderer.CastingTableRenderer;
import exter.foundry.client.renderer.CastingTableRendererBlock;
import exter.foundry.integration.ModIntegrationManager;
import exter.foundry.material.MaterialRegistry;
import exter.foundry.material.OreDictMaterial;
import exter.foundry.material.OreDictType;
import exter.foundry.proxy.CommonProxy;
import exter.foundry.tileentity.TileEntityCastingTableBlock;
import exter.foundry.tileentity.TileEntityCastingTableIngot;
import exter.foundry.tileentity.TileEntityCastingTablePlate;
import exter.foundry.tileentity.TileEntityCastingTableRod;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class ClientProxy
extends CommonProxy {
    @Override
    public void init() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCastingTableIngot.class, (TileEntitySpecialRenderer)new CastingTableRenderer(6, 10, 4, 12, 13, 16));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCastingTablePlate.class, (TileEntitySpecialRenderer)new CastingTableRenderer(3, 13, 3, 13, 14, 16));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCastingTableRod.class, (TileEntitySpecialRenderer)new CastingTableRenderer(7, 9, 2, 14, 14, 16));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCastingTableBlock.class, (TileEntitySpecialRenderer)new CastingTableRendererBlock());
        ModIntegrationManager.clientInit();
    }

    @Override
    public void postInit() {
        NonNullList ores;
        block0: for (OreDictMaterial material : OreDictMaterial.MATERIALS) {
            ores = OreDictionary.getOres((String)(material.default_prefix + material.suffix), (boolean)false);
            if (ores.size() > 0) {
                MaterialRegistry.INSTANCE.registerMaterialIcon(material.suffix, (ItemStack)ores.get(0));
                continue;
            }
            for (OreDictType type : OreDictType.TYPES) {
                ores = OreDictionary.getOres((String)(type.prefix + material.suffix), (boolean)false);
                if (ores.size() <= 0) continue;
                MaterialRegistry.INSTANCE.registerMaterialIcon(material.suffix, (ItemStack)ores.get(0));
                continue block0;
            }
        }
        block2: for (OreDictType type : OreDictType.TYPES) {
            ores = OreDictionary.getOres((String)(type.prefix + type.default_suffix), (boolean)false);
            if (ores.size() > 0) {
                MaterialRegistry.INSTANCE.registerTypeIcon(type.name, (ItemStack)ores.get(0));
                continue;
            }
            for (OreDictMaterial material : OreDictMaterial.MATERIALS) {
                ores = OreDictionary.getOres((String)(type.prefix + material.suffix), (boolean)false);
                if (ores.size() <= 0) continue;
                MaterialRegistry.INSTANCE.registerTypeIcon(type.name, (ItemStack)ores.get(0));
                continue block2;
            }
        }
        ModIntegrationManager.clientPostInit();
    }

    @Override
    public void preInit() {
        MaterialRegistry.INSTANCE.initIcons();
        ModIntegrationManager.clientPreInit();
    }

    private void registerItemModel(Block block, String name) {
        this.registerItemModel(Item.func_150898_a((Block)block), name);
    }

    private void registerItemModel(Block block, String name, int meta) {
        this.registerItemModel(Item.func_150898_a((Block)block), name, meta);
    }

    private void registerItemModel(Item item, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("foundry:" + name, "inventory"));
    }

    private void registerItemModel(Item item, String name, int meta) {
        name = "foundry:" + name;
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation(name)});
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
    }
}

