/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.top;

import io.netty.buffer.ByteBuf;
import java.awt.Color;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.apiimpl.client.ElementProgressRender;
import mcjty.theoneprobe.apiimpl.client.ElementTextRender;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import mcjty.theoneprobe.network.NetworkTools;
import mcjty.theoneprobe.rendering.RenderHelper;

public class ElementFluid
implements IElement {
    public static int ELEMENT_FLUID;
    private final String fluidName;
    private final int amount;
    private final int capacity;
    private final int color1;
    private final int color2;
    private final boolean sneaking;

    public ElementFluid(String fluidName, int amount, int capacity, int color1, boolean sneaking) {
        this.fluidName = fluidName;
        this.amount = amount;
        this.capacity = capacity;
        this.color1 = color1;
        this.color2 = new Color(this.color1).darker().hashCode();
        this.sneaking = sneaking;
    }

    public ElementFluid(ByteBuf buf) {
        this.fluidName = NetworkTools.readString((ByteBuf)buf);
        this.amount = buf.readInt();
        this.capacity = buf.readInt();
        this.color1 = buf.readInt();
        this.color2 = new Color(this.color1).darker().hashCode();
        this.sneaking = buf.readBoolean();
    }

    public void render(int x, int y) {
        ElementProgressRender.render((IProgressStyle)new ProgressStyle().filledColor(this.color1).alternateFilledColor(this.color2).showText(false), (long)this.amount, (long)this.capacity, (int)x, (int)y, (int)100, (int)12);
        for (int i = 1; i < 10; ++i) {
            RenderHelper.drawVerticalLine((int)(x + i * 10), (int)(y + 1), (int)(y + (i == 5 ? 11 : 6)), (int)-9013642);
        }
        if (this.sneaking) {
            ElementTextRender.render((String)(this.amount > 0 ? this.amount + " mB / " + this.capacity + " mB" : "0 mB"), (int)(x + 3), (int)(y + 2));
        } else {
            ElementTextRender.render((String)this.fluidName, (int)(x + 3), (int)(y + 2));
        }
    }

    public int getWidth() {
        return 100;
    }

    public int getHeight() {
        return 12;
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writeString((ByteBuf)buf, (String)this.fluidName);
        buf.writeInt(this.amount);
        buf.writeInt(this.capacity);
        buf.writeInt(this.color1);
        buf.writeBoolean(this.sneaking);
    }

    public int getID() {
        return ELEMENT_FLUID;
    }
}

