/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.jei;

import exter.foundry.api.recipe.IMoldRecipe;
import exter.foundry.util.MiscUtil;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.elements.DrawableResource;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class MoldStationJEI {

    public static class Wrapper
    implements IRecipeWrapper {
        private final IMoldRecipe recipe;
        private final IDrawable[] carve_drawables = new IDrawable[4];

        public Wrapper(IMoldRecipe recipe) {
            ResourceLocation location = new ResourceLocation("foundry", "textures/gui/moldstation.png");
            for (int i = 0; i < 4; ++i) {
                this.carve_drawables[i] = new DrawableResource(location, 176, 107 + i * 11, 11, 11, 0, 0, 0, 0, 256, 256);
            }
            this.recipe = recipe;
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            if (this.carve_drawables != null) {
                int width = this.recipe.getWidth();
                int height = this.recipe.getHeight();
                int[] grid = this.recipe.getRecipeGrid();
                int left = 3 - MiscUtil.divCeil(width, 2);
                int top = 3 - MiscUtil.divCeil(height, 2);
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int i = grid[y * width + x];
                        if (i <= 0) continue;
                        this.carve_drawables[i - 1].draw(minecraft, 7 + (x + left) * 11, 7 + (y + top) * 11);
                    }
                }
            }
        }

        public boolean equals(Object other) {
            return this.recipe == other;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.recipe.getOutput());
        }

        public List<String> getTooltipStrings(int mx, int my) {
            int width = this.recipe.getWidth();
            int height = this.recipe.getHeight();
            if (mx >= 7 && mx < 73 && my >= 7 && my < 73) {
                int x = (mx - 7) / 11 - (3 - MiscUtil.divCeil(width, 2));
                int y = (my - 7) / 11 - (3 - MiscUtil.divCeil(height, 2));
                int depth = 0;
                if (x >= 0 && x < width && y >= 0 && y < height) {
                    depth = this.recipe.getRecipeGrid()[y * width + x];
                }
                return Collections.singletonList("Depth: " + depth);
            }
            return null;
        }

        public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
            return false;
        }
    }

    public static class Category
    implements IRecipeCategory<Wrapper> {
        protected final ResourceLocation background_location;
        @Nonnull
        protected final IDrawableAnimated arrow;
        @Nonnull
        private final IDrawable background;
        @Nonnull
        private final String localizedName;
        @Nonnull
        private final IDrawable grid_drawable;

        public Category(IJeiHelpers helpers) {
            IGuiHelper guiHelper = helpers.getGuiHelper();
            this.background_location = new ResourceLocation("foundry", "textures/gui/moldstation.png");
            this.grid_drawable = guiHelper.createDrawable(this.background_location, 176, 31, 76, 76);
            IDrawableStatic arrowDrawable = guiHelper.createDrawable(this.background_location, 176, 14, 24, 17);
            this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
            ResourceLocation location = new ResourceLocation("foundry", "textures/gui/moldstation.png");
            this.background = guiHelper.createDrawable(location, 36, 14, 133, 81);
            this.localizedName = Translator.translateToLocal((String)("gui.jei." + this.getUid()));
        }

        public void drawExtras(Minecraft minecraft) {
            this.grid_drawable.draw(minecraft, 2, 2);
            this.arrow.draw(minecraft, 81, 25);
        }

        @Nonnull
        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }

        public String getModName() {
            return "foundry";
        }

        @Nonnull
        public String getTitle() {
            return this.localizedName;
        }

        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            return Collections.emptyList();
        }

        @Nonnull
        public String getUid() {
            return "foundry.mold";
        }

        public void setRecipe(IRecipeLayout recipeLayout, Wrapper recipeWrapper, IIngredients ingredients) {
            IGuiItemStackGroup gui_items = recipeLayout.getItemStacks();
            gui_items.init(0, false, 110, 23);
            gui_items.set(0, (List)ingredients.getOutputs(ItemStack.class).get(0));
        }
    }
}

