/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.jei;

import exter.foundry.api.recipe.IMeltingRecipe;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.elements.DrawableResource;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class MeltingJEI {

    public static class Wrapper
    implements IRecipeWrapper {
        private final IDrawable temp;
        private final IMeltingRecipe recipe;

        public Wrapper(IMeltingRecipe recipe) {
            this.recipe = recipe;
            ResourceLocation background_location = new ResourceLocation("foundry", "textures/gui/crucible.png");
            this.temp = new DrawableResource(background_location, 176, 53, (recipe.getMeltingPoint() * 100 - 30000) * 54 / 470000, 12, 0, 0, 0, 0, 256, 256);
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            if (this.temp != null) {
                this.temp.draw(minecraft, 11, 41);
            }
            minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gui.jei.foundry.melting.point", (Object[])new Object[]{this.recipe.getMeltingPoint()}), 14, 28, 0);
        }

        public boolean equals(Object other) {
            return this.recipe == other;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(this.recipe.getInput().getItems()));
            ingredients.setOutput(VanillaTypes.FLUID, (Object)this.recipe.getOutput());
        }

        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            return null;
        }

        public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
            return false;
        }
    }

    public static class Category
    implements IRecipeCategory<Wrapper> {
        protected final ResourceLocation backgroundLocation;
        @Nonnull
        protected final IDrawableAnimated arrow;
        @Nonnull
        private final IDrawable background;
        @Nonnull
        private final String localizedName;
        @Nonnull
        private final IDrawable tank_overlay;

        public Category(IJeiHelpers helpers) {
            IGuiHelper guiHelper = helpers.getGuiHelper();
            this.backgroundLocation = new ResourceLocation("foundry", "textures/gui/crucible.png");
            IDrawableStatic arrowDrawable = guiHelper.createDrawable(this.backgroundLocation, 176, 78, 24, 17);
            this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
            ResourceLocation location = new ResourceLocation("foundry", "textures/gui/crucible.png");
            this.background = guiHelper.createDrawable(location, 30, 16, 94, 54);
            this.tank_overlay = guiHelper.createDrawable(location, 176, 0, 16, 47);
            this.localizedName = I18n.func_135052_a((String)("gui.jei." + this.getUid()), (Object[])new Object[0]);
        }

        public void drawExtras(Minecraft minecraft) {
            this.arrow.draw(minecraft, 49, 7);
        }

        @Nonnull
        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }

        public String getModName() {
            return "foundry";
        }

        public String getTitle() {
            return this.localizedName;
        }

        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            return Collections.emptyList();
        }

        @Nonnull
        public String getUid() {
            return "foundry.melting";
        }

        public void setRecipe(IRecipeLayout recipeLayout, Wrapper recipeWrapper, IIngredients ingredients) {
            IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
            IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
            guiItemStacks.init(0, true, 24, 6);
            guiFluidStacks.init(1, false, 77, 6, 16, 47, 6000, false, this.tank_overlay);
            guiItemStacks.set(0, (List)ingredients.getInputs(ItemStack.class).get(0));
            guiFluidStacks.set(1, (List)ingredients.getOutputs(FluidStack.class).get(0));
        }
    }
}

