/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.jei;

import exter.foundry.api.recipe.IInfuserRecipe;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class InfuserJEI {

    public static class Wrapper
    implements IRecipeWrapper {
        private final IInfuserRecipe recipe;

        public Wrapper(IInfuserRecipe recipe) {
            this.recipe = recipe;
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            minecraft.field_71466_p.func_78276_b(this.recipe.getEnergyNeeded() + " FE", 0, 38, 0);
        }

        public boolean equals(Object other) {
            return this.recipe == other;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInput(FluidStack.class, (Object)this.recipe.getInputFluid());
            ingredients.setInputLists(ItemStack.class, Collections.singletonList(this.recipe.getInput().getItems()));
            ingredients.setOutput(FluidStack.class, (Object)this.recipe.getOutput());
        }

        public List<String> getTooltipStrings(int x, int y) {
            return null;
        }

        public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
            return false;
        }
    }

    public static class Category
    implements IRecipeCategory<Wrapper> {
        protected final ResourceLocation background_location;
        @Nonnull
        private final IDrawable background;
        @Nonnull
        private final String localizedName;
        @Nonnull
        private final IDrawable tank_overlay;
        @Nonnull
        protected final IDrawableAnimated arrow;

        public Category(IJeiHelpers helpers) {
            IGuiHelper guiHelper = helpers.getGuiHelper();
            this.background_location = new ResourceLocation("foundry", "textures/gui/infuser.png");
            IDrawableStatic arrowDrawable = guiHelper.createDrawable(this.background_location, 176, 53, 24, 17);
            this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
            ResourceLocation location = new ResourceLocation("foundry", "textures/gui/infuser.png");
            this.background = guiHelper.createDrawable(location, 15, 41, 137, 51);
            this.tank_overlay = guiHelper.createDrawable(location, 176, 0, 16, 47);
            this.localizedName = I18n.func_135052_a((String)("gui.jei." + this.getUid()), (Object[])new Object[0]);
        }

        public void drawExtras(Minecraft minecraft) {
            this.arrow.draw(minecraft, 34, 18);
        }

        @Nonnull
        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }

        public String getModName() {
            return "Zen: Foundry";
        }

        @Nonnull
        public String getTitle() {
            return this.localizedName;
        }

        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            return Collections.emptyList();
        }

        @Nonnull
        public String getUid() {
            return "foundry.infuser";
        }

        public void setRecipe(IRecipeLayout recipeLayout, Wrapper recipeWrapper, IIngredients ingredients) {
            IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
            guiFluidStacks.init(0, true, 59, 2, 16, 47, 5000, false, this.tank_overlay);
            guiFluidStacks.init(1, false, 108, 2, 16, 47, 5000, false, this.tank_overlay);
            guiFluidStacks.set(0, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
            guiFluidStacks.set(1, (List)ingredients.getOutputs(VanillaTypes.FLUID).get(0));
            IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
            guiItemStacks.init(0, true, 14, 17);
            guiItemStacks.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        }
    }
}

