/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.jei;

import exter.foundry.api.recipe.ICastingTableRecipe;
import exter.foundry.block.BlockCastingTable;
import exter.foundry.block.FoundryBlocks;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IStackHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class CastingTableJEI {
    private final ItemStack table_item;
    private final String name;
    private final BlockCastingTable.EnumTable type;
    private final String UID;

    public CastingTableJEI(BlockCastingTable.EnumTable table) {
        this.type = table;
        this.table_item = FoundryBlocks.block_casting_table.asItemStack(table);
        this.name = table.name;
        this.UID = "foundry.casting_table." + this.name;
    }

    public BlockCastingTable.EnumTable getType() {
        return this.type;
    }

    public String getUID() {
        return this.UID;
    }

    public static class Wrapper
    implements IRecipeWrapper {
        private final ICastingTableRecipe recipe;
        private final String name;

        public Wrapper(ICastingTableRecipe recipe) {
            this.recipe = recipe;
            this.name = recipe.getTableType().name().toLowerCase();
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        }

        public boolean equals(Object other) {
            return this.recipe == other;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInput(VanillaTypes.FLUID, (Object)this.recipe.getInput());
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.recipe.getOutput());
        }

        public String getName() {
            return this.name;
        }

        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            return null;
        }

        public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
            return false;
        }
    }

    public class Category
    implements IRecipeCategory<Wrapper> {
        protected final ResourceLocation backgroundLocation;
        @Nonnull
        private final IDrawable background;
        @Nonnull
        private final String localizedName;
        private final IJeiHelpers helpers;

        public Category(IJeiHelpers helpers) {
            this.helpers = helpers;
            IGuiHelper guiHelper = helpers.getGuiHelper();
            this.backgroundLocation = new ResourceLocation("foundry", "textures/gui/casting_table_jei.png");
            ResourceLocation location = new ResourceLocation("foundry", "textures/gui/casting_table_jei.png");
            this.background = guiHelper.createDrawable(location, 0, 0, 74, 59);
            this.localizedName = I18n.func_135052_a((String)("gui.jei." + this.getUid()), (Object[])new Object[0]);
        }

        public void drawExtras(Minecraft minecraft) {
        }

        @Nonnull
        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }

        public String getModName() {
            return "foundry";
        }

        @Nonnull
        public String getTitle() {
            return this.localizedName;
        }

        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            return Collections.emptyList();
        }

        @Nonnull
        public String getUid() {
            return CastingTableJEI.this.UID;
        }

        public void setRecipe(IRecipeLayout recipeLayout, Wrapper recipeWrapper, IIngredients ingredients) {
            IGuiItemStackGroup gui_items = recipeLayout.getItemStacks();
            IGuiFluidStackGroup gui_fluids = recipeLayout.getFluidStacks();
            IStackHelper stack_helper = this.helpers.getStackHelper();
            List input = (List)ingredients.getInputs(FluidStack.class).get(0);
            gui_items.init(0, false, 53, 20);
            gui_items.init(1, true, 3, 39);
            gui_fluids.init(2, true, 4, 4, 16, 24, ((FluidStack)input.get((int)0)).amount, false, null);
            gui_items.set(0, stack_helper.toItemStackList(ingredients.getOutputs(ItemStack.class).get(0)));
            gui_items.set(1, CastingTableJEI.this.table_item);
            gui_fluids.set(2, (FluidStack)input.get(0));
        }
    }
}

