/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.jei;

import com.google.common.collect.ImmutableList;
import exter.foundry.api.recipe.ICastingRecipe;
import exter.foundry.api.recipe.matcher.IItemMatcher;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class CastingJEI {

    public static class Wrapper
    implements IRecipeWrapper {
        @Nonnull
        private final ICastingRecipe recipe;

        public Wrapper(ICastingRecipe recipe) {
            this.recipe = recipe;
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        }

        public boolean equals(Object other) {
            return this.recipe == other;
        }

        public void getIngredients(IIngredients ingredients) {
            IItemMatcher extra = this.recipe.getInputExtra();
            List<Object> extra_items = extra != null ? extra.getItems() : Collections.emptyList();
            ingredients.setInputs(FluidStack.class, Collections.singletonList(this.recipe.getInput()));
            ingredients.setInputLists(ItemStack.class, (List)ImmutableList.of(Collections.singletonList(this.recipe.getMold()), extra_items));
            ingredients.setOutput(ItemStack.class, (Object)this.recipe.getOutput());
        }

        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            return null;
        }

        public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
            return false;
        }
    }

    public static class Category
    implements IRecipeCategory<Wrapper> {
        protected final ResourceLocation backgroundLocation;
        @Nonnull
        protected final IDrawableAnimated arrow;
        @Nonnull
        private final IDrawable background;
        @Nonnull
        private final String localizedName;
        @Nonnull
        private final IDrawable tank_overlay;

        public Category(IJeiHelpers helpers) {
            IGuiHelper guiHelper = helpers.getGuiHelper();
            this.backgroundLocation = new ResourceLocation("foundry", "textures/gui/caster.png");
            IDrawableStatic arrowDrawable = guiHelper.createDrawable(this.backgroundLocation, 176, 53, 24, 17);
            this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
            ResourceLocation location = new ResourceLocation("foundry", "textures/gui/caster.png");
            this.background = guiHelper.createDrawable(location, 38, 16, 68, 54);
            this.tank_overlay = guiHelper.createDrawable(location, 176, 0, 16, 47);
            this.localizedName = I18n.func_135052_a((String)("gui.jei." + this.getUid()), (Object[])new Object[0]);
        }

        public void drawExtras(Minecraft minecraft) {
            this.arrow.draw(minecraft, 22, 35);
        }

        @Nonnull
        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }

        public String getModName() {
            return "foundry";
        }

        @Nonnull
        public String getTitle() {
            return this.localizedName;
        }

        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            return Collections.emptyList();
        }

        @Nonnull
        public String getUid() {
            return "foundry.casting";
        }

        public void setRecipe(IRecipeLayout recipeLayout, Wrapper recipeWrapper, IIngredients ingredients) {
            IGuiItemStackGroup gui_items = recipeLayout.getItemStacks();
            IGuiFluidStackGroup gui_fluids = recipeLayout.getFluidStacks();
            gui_items.init(0, false, 47, 34);
            gui_items.init(1, true, 27, 4);
            gui_items.init(2, true, 47, 4);
            gui_fluids.init(3, true, 1, 5, 16, 47, 6000, false, this.tank_overlay);
            gui_items.set(0, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
            gui_items.set(1, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
            gui_items.set(2, (List)ingredients.getInputs(VanillaTypes.ITEM).get(1));
            gui_fluids.set(3, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
        }
    }
}

