/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.jei;

import com.google.common.collect.ImmutableList;
import exter.foundry.api.recipe.IAlloyingCrucibleRecipe;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class AlloyingCrucibleJEI {

    public static class Wrapper
    implements IRecipeWrapper {
        private final IAlloyingCrucibleRecipe recipe;

        public Wrapper(IAlloyingCrucibleRecipe recipe) {
            this.recipe = recipe;
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        }

        public boolean equals(Object other) {
            return this.recipe == other;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setOutput(VanillaTypes.FLUID, (Object)this.recipe.getOutput());
            ingredients.setInputs(VanillaTypes.FLUID, (List)ImmutableList.of((Object)this.recipe.getInputA(), (Object)this.recipe.getInputB()));
        }

        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            return null;
        }

        public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
            return false;
        }
    }

    public static class Category
    implements IRecipeCategory<Wrapper> {
        protected final ResourceLocation backgroundLocation;
        @Nonnull
        private final IDrawable background;
        @Nonnull
        private final String localizedName;
        @Nonnull
        private final IDrawable tank_overlay;

        public Category(IJeiHelpers helpers) {
            IGuiHelper guiHelper = helpers.getGuiHelper();
            this.backgroundLocation = new ResourceLocation("foundry", "textures/gui/alloyingcrucible.png");
            ResourceLocation location = new ResourceLocation("foundry", "textures/gui/alloyingcrucible.png");
            this.background = guiHelper.createDrawable(location, 33, 43, 110, 39);
            this.tank_overlay = guiHelper.createDrawable(location, 176, 0, 16, 35);
            this.localizedName = Translator.translateToLocal((String)("gui.jei." + this.getUid()));
        }

        public void drawExtras(Minecraft minecraft) {
        }

        @Nonnull
        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }

        public String getModName() {
            return "foundry";
        }

        @Nonnull
        public String getTitle() {
            return this.localizedName;
        }

        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            return Collections.emptyList();
        }

        @Nonnull
        public String getUid() {
            return "foundry.alloyingcrucible";
        }

        public void setRecipe(IRecipeLayout recipeLayout, Wrapper recipeWrapper, IIngredients ingredients) {
            IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
            FluidStack out = (FluidStack)((List)ingredients.getOutputs(FluidStack.class).get(0)).get(0);
            List in_a = (List)ingredients.getInputs(FluidStack.class).get(0);
            List in_b = (List)ingredients.getInputs(FluidStack.class).get(1);
            int amount = Integer.max(out.amount, Integer.max(((FluidStack)in_a.get((int)0)).amount, ((FluidStack)in_b.get((int)0)).amount));
            guiFluidStacks.init(0, true, 2, 2, 16, 35, amount, false, this.tank_overlay);
            guiFluidStacks.init(1, true, 92, 2, 16, 35, amount, false, this.tank_overlay);
            guiFluidStacks.init(2, false, 47, 2, 16, 35, amount, false, this.tank_overlay);
            guiFluidStacks.set(0, in_a);
            guiFluidStacks.set(1, in_b);
            guiFluidStacks.set(2, out);
        }
    }
}

