/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.jei;

import exter.foundry.api.recipe.IAlloyMixerRecipe;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class AlloyMixerJEI {

    public static class Wrapper
    implements IRecipeWrapper {
        private final IAlloyMixerRecipe recipe;

        public Wrapper(IAlloyMixerRecipe recipe) {
            this.recipe = recipe;
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        }

        public boolean equals(Object other) {
            return this.recipe == other;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputs(VanillaTypes.FLUID, this.recipe.getInputs());
            ingredients.setOutput(VanillaTypes.FLUID, (Object)this.recipe.getOutput());
        }

        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            return null;
        }

        public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
            return false;
        }
    }

    public static class Category
    implements IRecipeCategory<Wrapper> {
        protected final ResourceLocation backgroundLocation;
        @Nonnull
        private final IDrawable background;
        @Nonnull
        private final String localizedName;
        @Nonnull
        private final IDrawable tank_overlay;

        public Category(IJeiHelpers helpers) {
            IGuiHelper guiHelper = helpers.getGuiHelper();
            this.backgroundLocation = new ResourceLocation("foundry", "textures/gui/alloymixer.png");
            ResourceLocation location = new ResourceLocation("foundry", "textures/gui/alloymixer.png");
            this.background = guiHelper.createDrawable(location, 18, 44, 132, 37);
            this.tank_overlay = guiHelper.createDrawable(location, 176, 0, 16, 35);
            this.localizedName = Translator.translateToLocal((String)("gui.jei." + this.getUid()));
        }

        public void drawExtras(Minecraft minecraft) {
        }

        @Nonnull
        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }

        public String getModName() {
            return "foundry";
        }

        @Nonnull
        public String getTitle() {
            return this.localizedName;
        }

        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            return Collections.emptyList();
        }

        @Nonnull
        public String getUid() {
            return "foundry.alloymixer";
        }

        public void setRecipe(IRecipeLayout recipeLayout, Wrapper recipeWrapper, IIngredients ingredients) {
            int i;
            IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
            List in = ingredients.getInputs(FluidStack.class);
            FluidStack out = (FluidStack)((List)ingredients.getOutputs(FluidStack.class).get(0)).get(0);
            int out_amount = out.amount;
            for (i = 0; i < in.size(); ++i) {
                int amount = ((FluidStack)((List)in.get((int)i)).get((int)0)).amount;
                if (amount <= out_amount) continue;
                out_amount = amount;
            }
            guiFluidStacks.init(5, false, 115, 1, 16, 35, out_amount, false, this.tank_overlay);
            for (i = 0; i < in.size(); ++i) {
                guiFluidStacks.init(i, true, 8 + 21 * i, 1, 16, 35, out_amount, false, this.tank_overlay);
                guiFluidStacks.set(i, (List)in.get(i));
            }
            guiFluidStacks.set(5, (List)ingredients.getOutputs(FluidStack.class).get(0));
        }
    }
}

