/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.crafttweaker.orestack;

import crafttweaker.annotations.BracketHandler;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemCondition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IItemTransformer;
import crafttweaker.api.item.IItemTransformerNew;
import crafttweaker.api.item.IngredientOr;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import exter.foundry.api.recipe.matcher.OreMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;

@BracketHandler(priority=100)
public class CrTOreStack
implements IIngredient {
    private final OreMatcher stack;

    public CrTOreStack(OreMatcher stack) {
        this.stack = stack;
    }

    public IIngredient amount(int amount) {
        return new CrTOreStack(new OreMatcher(this.stack.getOreName(), this.stack.getAmount() * amount));
    }

    public IItemStack applyTransform(IItemStack arg0, IPlayer arg1) {
        return null;
    }

    public boolean contains(IIngredient ingredient) {
        List items = ingredient.getItems();
        for (IItemStack item : items) {
            if (this.matches(item)) continue;
            return false;
        }
        return true;
    }

    public int getAmount() {
        return this.stack.getAmount();
    }

    public Object getInternal() {
        return this.stack;
    }

    public IItemStack[] getItemArray() {
        return this.getItems().toArray(new IItemStack[0]);
    }

    public List<IItemStack> getItems() {
        ArrayList<IItemStack> result = new ArrayList<IItemStack>();
        for (ItemStack item : this.stack.getItems()) {
            result.add(CraftTweakerMC.getIItemStack((ItemStack)item));
        }
        return result;
    }

    public List<ILiquidStack> getLiquids() {
        return Collections.emptyList();
    }

    public String getMark() {
        return null;
    }

    public boolean hasTransformers() {
        return false;
    }

    public IIngredient marked(String arg0) {
        return this;
    }

    public boolean matches(IItemStack iitem) {
        ItemStack item = CraftTweakerMC.getItemStack((IItemStack)iitem);
        return this.stack.apply(item);
    }

    public boolean matches(ILiquidStack arg0) {
        return false;
    }

    public boolean matchesExact(IItemStack iitem) {
        return this.matches(iitem);
    }

    public IIngredient only(IItemCondition arg0) {
        return this;
    }

    public IIngredient or(IIngredient ingredient) {
        return new IngredientOr((IIngredient)this, ingredient);
    }

    public IIngredient transform(IItemTransformer arg0) {
        return this;
    }

    public IIngredient transformNew(IItemTransformerNew transformer) {
        return this;
    }

    public IItemStack applyNewTransform(IItemStack item) {
        return item;
    }

    public boolean hasNewTransformers() {
        return false;
    }

    public String toCommandString() {
        return this.stack.toString();
    }

    public String toString() {
        return this.toCommandString();
    }
}

