/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import exter.foundry.api.recipe.IMoldRecipe;
import exter.foundry.integration.ModIntegrationCrafttweaker;
import exter.foundry.integration.crafttweaker.AddRemoveAction;
import exter.foundry.integration.crafttweaker.CrTHelper;
import exter.foundry.recipes.MoldRecipe;
import exter.foundry.recipes.manager.MoldRecipeManager;
import java.util.List;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.foundry.MoldStation")
public class CrTMoldStationHandler {
    @ZenMethod
    public static void addRecipe(IItemStack output, int width, int height, int[] grid) {
        ModIntegrationCrafttweaker.queueAdd(() -> {
            MoldRecipe recipe = null;
            try {
                recipe = new MoldRecipe(CraftTweakerMC.getItemStack((IItemStack)output), width, height, grid);
            }
            catch (IllegalArgumentException e) {
                CrTHelper.printCrt("Invalid mold station recipe: " + e.getMessage());
                return;
            }
            CraftTweakerAPI.apply((IAction)new MoldStationAction((IMoldRecipe)recipe).action_add);
        });
    }

    @ZenMethod
    public static void removeRecipe(int[] grid) {
        ModIntegrationCrafttweaker.queueRemove(() -> {
            if (grid.length != 36) {
                CraftTweakerAPI.logWarning((String)("Invalid mold station grid size: expected 36 instead of " + grid.length));
                return;
            }
            IMoldRecipe recipe = MoldRecipeManager.INSTANCE.findRecipe(grid);
            if (recipe == null) {
                CraftTweakerAPI.logWarning((String)"Mold station recipe not found.");
                return;
            }
            CraftTweakerAPI.apply((IAction)new MoldStationAction((IMoldRecipe)recipe).action_remove);
        });
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        if (output.isEmpty()) {
            return;
        }
        ModIntegrationCrafttweaker.queueRemove(() -> {
            List<IMoldRecipe> recipes = MoldRecipeManager.INSTANCE.getRecipes();
            recipes.stream().filter(r -> output.matches(CraftTweakerMC.getIItemStack((ItemStack)r.getOutput()))).forEach(r -> CraftTweakerAPI.apply((IAction)new MoldStationAction((IMoldRecipe)r).action_remove));
        });
    }

    @ZenMethod
    public static void clear() {
        ModIntegrationCrafttweaker.queueClear(MoldRecipeManager.INSTANCE.getRecipes());
    }

    public static class MoldStationAction
    extends AddRemoveAction {
        IMoldRecipe recipe;

        public MoldStationAction(IMoldRecipe recipe) {
            this.recipe = recipe;
        }

        @Override
        protected void add() {
            MoldRecipeManager.INSTANCE.addRecipe(this.recipe);
        }

        @Override
        public String getDescription() {
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("( %d, %d, [", this.recipe.getWidth(), this.recipe.getHeight()));
            boolean comma = false;
            for (int r : this.recipe.getRecipeGrid()) {
                if (comma) {
                    builder.append(',');
                }
                builder.append(String.format(" %d", r));
                comma = true;
            }
            builder.append(String.format("] ) -> %s", CrTHelper.getItemDescription(this.recipe.getOutput())));
            return builder.toString();
        }

        @Override
        public String getRecipeType() {
            return "mold station";
        }

        @Override
        protected void remove() {
            MoldRecipeManager.INSTANCE.removeRecipe(this.recipe);
        }
    }
}

