/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import exter.foundry.api.recipe.IInfuserRecipe;
import exter.foundry.integration.ModIntegrationCrafttweaker;
import exter.foundry.integration.crafttweaker.AddRemoveAction;
import exter.foundry.integration.crafttweaker.CrTHelper;
import exter.foundry.recipes.InfuserRecipe;
import exter.foundry.recipes.manager.InfuserRecipeManager;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.foundry.Infuser")
public class CrTInfuserHandler {
    @ZenMethod
    public static void addRecipe(ILiquidStack output, ILiquidStack input, IIngredient substance, int energy) {
        ModIntegrationCrafttweaker.queueAdd(() -> {
            InfuserRecipe recipe = null;
            try {
                recipe = new InfuserRecipe(CraftTweakerMC.getLiquidStack((ILiquidStack)output), CraftTweakerMC.getLiquidStack((ILiquidStack)input), CrTHelper.getIngredient(substance), energy);
            }
            catch (IllegalArgumentException e) {
                CrTHelper.printCrt("Invalid infuser recipe: " + e.getMessage());
                return;
            }
            CraftTweakerAPI.apply((IAction)new InfuserAction((IInfuserRecipe)recipe).action_add);
        });
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack input, IItemStack substance) {
        ModIntegrationCrafttweaker.queueRemove(() -> {
            IInfuserRecipe recipe = InfuserRecipeManager.INSTANCE.findRecipe(CraftTweakerMC.getLiquidStack((ILiquidStack)input), CraftTweakerMC.getItemStack((IItemStack)substance));
            if (recipe == null) {
                CraftTweakerAPI.logWarning((String)"Infuser recipe not found.");
                return;
            }
            CraftTweakerAPI.apply((IAction)new InfuserAction((IInfuserRecipe)recipe).action_remove);
        });
    }

    @ZenMethod
    public static void clear() {
        ModIntegrationCrafttweaker.queueClear(InfuserRecipeManager.INSTANCE.getRecipes());
    }

    public static class InfuserAction
    extends AddRemoveAction {
        IInfuserRecipe recipe;

        public InfuserAction(IInfuserRecipe recipe) {
            this.recipe = recipe;
        }

        @Override
        protected void add() {
            InfuserRecipeManager.INSTANCE.addRecipe(this.recipe);
        }

        @Override
        public String getDescription() {
            return String.format("( %s, %s ) -> %s", CrTHelper.getFluidDescription(this.recipe.getInputFluid()), CrTHelper.getItemDescription(this.recipe.getInput()), CrTHelper.getFluidDescription(this.recipe.getOutput()));
        }

        @Override
        public String getRecipeType() {
            return "infuser";
        }

        @Override
        protected void remove() {
            InfuserRecipeManager.INSTANCE.removeRecipe(this.recipe);
        }
    }
}

