/*
 * Decompiled with CFR 0.152.
 */
package exter.foundry.integration.crafttweaker;

import com.google.common.base.Preconditions;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import exter.foundry.api.recipe.matcher.IItemMatcher;
import exter.foundry.api.recipe.matcher.ItemStackMatcher;
import exter.foundry.api.recipe.matcher.OreMatcher;
import exter.foundry.config.FoundryConfig;
import exter.foundry.integration.crafttweaker.CrTItemMatcher;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CrTHelper {
    public static String getFluidDescription(ILiquidStack stack) {
        return CrTHelper.getFluidDescription(CraftTweakerMC.getLiquidStack((ILiquidStack)stack));
    }

    public static String getFluidDescription(FluidStack stack) {
        return String.format("<liquid:%s> * %d", stack.getFluid().getName(), stack.amount);
    }

    public static IItemMatcher getIngredient(IIngredient ingr) {
        if (ingr instanceof IItemStack) {
            return new ItemStackMatcher(CraftTweakerMC.getItemStack((IItemStack)((IItemStack)ingr)));
        }
        return new CrTItemMatcher(ingr);
    }

    public static String getItemDescription(IItemMatcher obj) {
        Preconditions.checkNotNull((Object)obj, (Object)"Cannot get description from a null matcher!");
        if (obj instanceof OreMatcher) {
            OreMatcher stack = (OreMatcher)obj;
            return String.format("<ore:%s> * %d", stack.getOreName(), stack.getAmount());
        }
        ItemStack stack = obj.getItem();
        String desc = String.format("<%s:%d>", stack.func_77973_b().getRegistryName(), stack.func_77952_i());
        if (stack.func_190916_E() > 1) {
            desc = desc + " * " + stack.func_190916_E();
        }
        if (stack.func_77942_o()) {
            desc = desc + " with tag " + stack.func_77978_p().toString();
        }
        return desc;
    }

    public static String getItemDescription(IItemStack stack) {
        return CrTHelper.getItemDescription(CraftTweakerMC.getItemStack((IItemStack)stack));
    }

    public static String getItemDescription(ItemStack stack) {
        String desc = String.format("<%s:%d> * %d", stack.func_77973_b().getRegistryName(), stack.func_77952_i(), stack.func_190916_E());
        if (stack.func_77942_o()) {
            desc = desc + " with tag " + stack.func_77978_p().toString();
        }
        return desc;
    }

    public static void printCrt(String print) {
        if (FoundryConfig.crtError) {
            CraftTweakerAPI.logError((String)print);
        } else {
            CraftTweakerAPI.logInfo((String)print);
        }
    }
}

